/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field103;
import com.prowidesoftware.swift.model.field.Field177;
import com.prowidesoftware.swift.model.field.Field243;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT028
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT028.class.getName());
    public static final String NAME = "028";

    public MT028(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT028(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT028 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT028(m);
    }

    public MT028() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT028(String sender, String receiver) {
        super(28, sender, receiver);
    }

    public MT028(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT028.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT028 object from FIN content with a Service Message. Check if the MT028 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT028 object from FIN content with message type " + param.getType());
        }
    }

    public static MT028 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT028(fin);
    }

    public MT028(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT028 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT028(stream);
    }

    public MT028(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT028 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT028(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT028 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT028 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT028 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT028 fromJson(String json) {
        return (MT028)AbstractMT.fromJson(json);
    }

    public Field103 getField103() {
        Tag t = this.tag("103");
        if (t != null) {
            return new Field103(t.getValue());
        }
        return null;
    }

    public Field243 getField243() {
        Tag t = this.tag("243");
        if (t != null) {
            return new Field243(t.getValue());
        }
        return null;
    }

    public List<Field177> getField177() {
        ArrayList<Field177> result = new ArrayList<Field177>();
        Tag[] tags = this.tags("177");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field177(tag.getValue()));
            }
        }
        return result;
    }
}

