/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field301;
import com.prowidesoftware.swift.model.field.Field302;
import com.prowidesoftware.swift.model.field.Field341;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT044
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT044.class.getName());
    public static final String NAME = "044";

    public MT044(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT044(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT044 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT044(m);
    }

    public MT044() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT044(String sender, String receiver) {
        super(44, sender, receiver);
    }

    public MT044(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT044.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT044 object from FIN content with a Service Message. Check if the MT044 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT044 object from FIN content with message type " + param.getType());
        }
    }

    public static MT044 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT044(fin);
    }

    public MT044(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT044 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT044(stream);
    }

    public MT044(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT044 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT044(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT044 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT044 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT044 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT044 fromJson(String json) {
        return (MT044)AbstractMT.fromJson(json);
    }

    public Field302 getField302() {
        Tag t = this.tag("302");
        if (t != null) {
            return new Field302(t.getValue());
        }
        return null;
    }

    public Field341 getField341() {
        Tag t = this.tag("341");
        if (t != null) {
            return new Field341(t.getValue());
        }
        return null;
    }

    public Field301 getField301() {
        Tag t = this.tag("301");
        if (t != null) {
            return new Field301(t.getValue());
        }
        return null;
    }
}

