/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field71G
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "71G";
    public static final String F_71G = "71G";
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;

    public Field71G() {
        super(2);
    }

    public Field71G(String value) {
        super(value);
    }

    public Field71G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"71G")) {
            throw new IllegalArgumentException("cannot create field 71G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field71G newInstance(Field71G source) {
        Field71G cp = new Field71G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("71G", value);
    }

    public static Tag emptyTag() {
        return new Tag("71G", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 71G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
        f.setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent2AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "CI";
    }

    @Override
    public String parserPattern() {
        return "SN";
    }

    @Override
    public String validatorPattern() {
        return "<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("currency", 1);
        this.labelMap.put("amount", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent1AsCurrency();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent2();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    public Field71G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field71G setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field71G setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field71G setCurrency(Currency component1) {
        return this.setComponent1(component1);
    }

    public Field71G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field71G setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field71G setAmount(String component2) {
        return this.setComponent2(component2);
    }

    public Field71G setAmount(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "71G";
    }

    public static Field71G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("71G");
        if (t == null) {
            return null;
        }
        return new Field71G(t);
    }

    public static Field71G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field71G.get(msg.getBlock4());
    }

    public static List<Field71G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field71G.getAll(msg.getBlock4());
    }

    public static List<Field71G> getAll(SwiftTagListBlock block) {
        ArrayList<Field71G> result = new ArrayList<Field71G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("71G");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field71G(f));
            }
        }
        return result;
    }

    public static Field71G fromJson(String json) {
        Field71G field = new Field71G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

