/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field62F;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT971
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT971.class.getName());
    public static final String NAME = "971";

    public MT971(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT971(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT971 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT971(m);
    }

    public MT971() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT971(String sender, String receiver) {
        super(971, sender, receiver);
    }

    public MT971(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT971.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT971 object from FIN content with a Service Message. Check if the MT971 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT971 object from FIN content with message type " + param.getType());
        }
    }

    public static MT971 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT971(fin);
    }

    public MT971(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT971 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT971(stream);
    }

    public MT971(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT971 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT971(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT971 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT971 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT971 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT971 fromJson(String json) {
        return (MT971)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public List<Field25> getField25() {
        ArrayList<Field25> result = new ArrayList<Field25>();
        Tag[] tags = this.tags("25");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field25(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field62F> getField62F() {
        ArrayList<Field62F> result = new ArrayList<Field62F>();
        Tag[] tags = this.tags("62F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field62F(tag.getValue()));
            }
        }
        return result;
    }
}

