/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BicValidationResult;
import com.prowidesoftware.swift.model.DistinguishedName;
import com.prowidesoftware.swift.utils.IsoUtils;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BIC {
    private static final transient Logger log = Logger.getLogger(BIC.class.getName());
    public static final transient String TEST8 = "TESTARZZ";
    public static final transient String TEST12 = "TESTARZZAXXX";
    public static final String PARTNER_PREFIX = "PTS";
    protected String branch = null;
    private String institution = null;
    private String country = null;
    private String location = null;
    private String subtype = null;

    public BIC(String bic) {
        this.parse(bic);
    }

    public BIC() {
    }

    protected void parse(String bic) {
        if (bic != null) {
            this.institution = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)0, (int)4));
            this.country = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)4, (int)6));
            this.location = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)6, (int)8));
            this.branch = bic.length() >= 12 ? StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)9)) : StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)8));
        }
    }

    public boolean isValid() {
        return this.validate() == BicValidationResult.OK;
    }

    public BicValidationResult validate() {
        if (this.institution == null || this.country == null || this.location == null) {
            return BicValidationResult.INVALID_LENGTH;
        }
        if (this.institution.length() != 4) {
            return BicValidationResult.INVALID_INSTITUTION_LENGTH.setFound(this.institution);
        }
        if (this.country.length() != 2) {
            return BicValidationResult.INVALID_COUNTRY_LENGTH.setFound(this.country);
        }
        if (this.location.length() != 2) {
            return BicValidationResult.INVALID_LOCATION_LENGTH.setFound(this.location);
        }
        if (this.branch != null && this.branch.length() != 3) {
            return BicValidationResult.INVALID_BRANCH_LENGTH.setFound(this.branch);
        }
        if (!this.isUpperCase(this.institution)) {
            return BicValidationResult.INVALID_INSTITUTION_CHARSET.setFound(this.institution);
        }
        if (!IsoUtils.getInstance().isValidISOCountry(this.country)) {
            return BicValidationResult.INVALID_COUNTRY.setFound(this.country);
        }
        if (!this.isUpperCaseOrDigit(this.location)) {
            return BicValidationResult.INVALID_LOCATION_CHARSET.setFound(this.location);
        }
        if (this.branch != null && !this.isUpperCaseOrDigit(this.branch)) {
            return BicValidationResult.INVALID_BRANCH_CHARSET.setFound(this.branch);
        }
        return BicValidationResult.OK;
    }

    private boolean isUpperCase(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isUpperCaseOrDigit(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i)) || Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBranchOrDefault() {
        return this.branch != null ? this.branch : "XXX";
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public boolean isTestAndTraining() {
        if (this.location != null) {
            return this.location.charAt(1) == '0';
        }
        return false;
    }

    public boolean isNonLive() {
        if (this.location != null) {
            return this.location.charAt(1) == '1';
        }
        return false;
    }

    public boolean isLive() {
        if (this.location != null) {
            return this.location.charAt(1) != '0' && this.location.charAt(1) != '1';
        }
        return false;
    }

    public String getBic8() {
        if (this.institution != null && this.country != null && this.location != null) {
            return this.institution + this.country + this.location;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BIC bic = (BIC)o;
        return Objects.equals(this.institution, bic.institution) && Objects.equals(this.country, bic.country) && Objects.equals(this.location, bic.location) && Objects.equals(this.branch, bic.branch) && Objects.equals(this.subtype, bic.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.institution, this.country, this.location, this.branch, this.subtype);
    }

    public String getBic11() {
        String bic8 = this.getBic8();
        if (bic8 != null) {
            return bic8 + this.getBranchOrDefault();
        }
        return null;
    }

    public String distinguishedName() {
        return this.distinguishedName(false);
    }

    public String distinguishedName(boolean includeDefaultBranch) {
        if (this.isTestAndTraining()) {
            log.warning("Distinguished Name must be constructed using Live BIC instead of Test&Training BIC: " + this.getBic8());
        }
        DistinguishedName.Builder dnBuilder = new DistinguishedName.Builder(this.getBic8());
        if (includeDefaultBranch || !Objects.equals(this.getBranchOrDefault().toUpperCase(), "XXX")) {
            dnBuilder.withBranch(this.getBranchOrDefault());
        }
        return dnBuilder.build().toString();
    }

    public String toString() {
        return this.getBic11();
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public BIC asTestBic() {
        BIC bic = new BIC(this.getBic11());
        if (bic.getLocation() == null || bic.getLocation().isEmpty()) {
            bic.setLocation("00");
        } else {
            bic.setLocation(bic.getLocation().charAt(0) + "0");
        }
        return bic;
    }
}

