/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field129
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "129";
    public static final String F_129 = "129";
    public static final Integer SECTION = 1;
    public static final Integer TOTAL = 2;

    public Field129() {
        super(2);
    }

    public Field129(String value) {
        super(value);
    }

    public Field129(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"129")) {
            throw new IllegalArgumentException("cannot create field 129 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field129 newInstance(Field129 source) {
        Field129 cp = new Field129();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("129", value);
    }

    public static Tag emptyTag() {
        return new Tag("129", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 129");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "NN";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "2n/2n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Section");
        result.add("Total");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "section");
        result.put(2, "total");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("section", 1);
        this.labelMap.put("total", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getSection() {
        return this.getComponent1();
    }

    public Long getSectionAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getTotal() {
        return this.getComponent2();
    }

    public Long getTotalAsLong() {
        return this.getComponent2AsLong();
    }

    public Field129 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field129 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field129 setSection(String component1) {
        return this.setComponent1(component1);
    }

    public Field129 setSection(Number component1) {
        return this.setComponent1(component1);
    }

    public Field129 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field129 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field129 setTotal(String component2) {
        return this.setComponent2(component2);
    }

    public Field129 setTotal(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "129";
    }

    public static Field129 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("129");
        if (t == null) {
            return null;
        }
        return new Field129(t);
    }

    public static Field129 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field129.get(msg.getBlock4());
    }

    public static List<Field129> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field129.getAll(msg.getBlock4());
    }

    public static List<Field129> getAll(SwiftTagListBlock block) {
        ArrayList<Field129> result = new ArrayList<Field129>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("129");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field129(f));
            }
        }
        return result;
    }

    public static Field129 fromJson(String json) {
        Field129 field = new Field129();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("section") != null) {
            field.setComponent1(jsonObject.get("section").getAsString());
        }
        if (jsonObject.get("total") != null) {
            field.setComponent2(jsonObject.get("total").getAsString());
        }
        return field;
    }
}

