/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field13A
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13A";
    public static final String F_13A = "13A";
    public static final Integer QUALIFIER = 1;
    public static final Integer NUMBER_ID = 2;
    public static final Integer NUMBER_IDENTIFICATION = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field13A() {
        super(2);
    }

    public Field13A(String value) {
        super(value);
    }

    public Field13A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"13A")) {
            throw new IllegalArgumentException("cannot create field 13A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field13A newInstance(Field13A source) {
        Field13A cp = new Field13A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("13A", value);
    }

    public static Tag emptyTag() {
        return new Tag("13A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return ":S//S";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//3!c";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Number Id");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "numberId");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("numberid", 2);
        this.labelMap.put("numberidentification", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNumberId() {
        return this.getComponent2();
    }

    public String getNumberIdentification() {
        return this.getNumberId();
    }

    public Field13A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13A setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field13A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13A setNumberId(String component2) {
        return this.setComponent2(component2);
    }

    public Field13A setNumberIdentification(String component2) {
        return this.setNumberId(component2);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "13A";
    }

    public static Field13A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13A");
        if (t == null) {
            return null;
        }
        return new Field13A(t);
    }

    public static Field13A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13A.get(msg.getBlock4());
    }

    public static List<Field13A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13A.getAll(msg.getBlock4());
    }

    public static List<Field13A> getAll(SwiftTagListBlock block) {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("13A");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field13A(f));
            }
        }
        return result;
    }

    public static Field13A fromJson(String json) {
        Field13A field = new Field13A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("numberIdentification") != null) {
            field.setComponent2(jsonObject.get("numberIdentification").getAsString());
        }
        if (jsonObject.get("numberId") != null) {
            field.setComponent2(jsonObject.get("numberId").getAsString());
        }
        return field;
    }
}

