/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field165
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "165";
    public static final String F_165 = "165";
    public static final Integer SERVICE_CODE = 1;
    public static final Integer PAYMENT_INFORMATION = 2;

    public Field165() {
        super(2);
    }

    public Field165(String value) {
        super(value);
    }

    public Field165(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"165")) {
            throw new IllegalArgumentException("cannot create field 165 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field165 newInstance(Field165 source) {
        Field165 cp = new Field165();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("165", value);
    }

    public static Tag emptyTag() {
        return new Tag("165", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/", "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 165");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "/S/S";
    }

    @Override
    public String validatorPattern() {
        return "/3!c/34x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Service Code");
        result.add("Payment Information");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "serviceCode");
        result.put(2, "paymentInformation");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("servicecode", 1);
        this.labelMap.put("paymentinformation", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getServiceCode() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPaymentInformation() {
        return this.getComponent2();
    }

    public Field165 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field165 setServiceCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field165 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field165 setPaymentInformation(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "165";
    }

    public static Field165 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("165");
        if (t == null) {
            return null;
        }
        return new Field165(t);
    }

    public static Field165 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field165.get(msg.getBlock4());
    }

    public static List<Field165> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field165.getAll(msg.getBlock4());
    }

    public static List<Field165> getAll(SwiftTagListBlock block) {
        ArrayList<Field165> result = new ArrayList<Field165>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("165");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field165(f));
            }
        }
        return result;
    }

    public static Field165 fromJson(String json) {
        Field165 field = new Field165();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("serviceCode") != null) {
            field.setComponent1(jsonObject.get("serviceCode").getAsString());
        }
        if (jsonObject.get("paymentInformation") != null) {
            field.setComponent2(jsonObject.get("paymentInformation").getAsString());
        }
        return field;
    }
}

