/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field28E
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "28E";
    public static final String F_28E = "28E";
    public static final Integer PAGE_NUMBER = 1;
    public static final Integer CONTINUATION_INDICATOR = 2;

    public Field28E() {
        super(2);
    }

    public Field28E(String value) {
        super(value);
    }

    public Field28E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"28E")) {
            throw new IllegalArgumentException("cannot create field 28E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field28E newInstance(Field28E source) {
        Field28E cp = new Field28E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("28E", value);
    }

    public static Tag emptyTag() {
        return new Tag("28E", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 28E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "NS";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "5n/4!c";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Page Number");
        result.add("Continuation Indicator");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "pageNumber");
        result.put(2, "continuationIndicator");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("pagenumber", 1);
        this.labelMap.put("continuationindicator", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getPageNumber() {
        return this.getComponent1();
    }

    public Long getPageNumberAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getContinuationIndicator() {
        return this.getComponent2();
    }

    public Field28E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field28E setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field28E setPageNumber(String component1) {
        return this.setComponent1(component1);
    }

    public Field28E setPageNumber(Number component1) {
        return this.setComponent1(component1);
    }

    public Field28E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field28E setContinuationIndicator(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "28E";
    }

    public static Field28E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("28E");
        if (t == null) {
            return null;
        }
        return new Field28E(t);
    }

    public static Field28E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field28E.get(msg.getBlock4());
    }

    public static List<Field28E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field28E.getAll(msg.getBlock4());
    }

    public static List<Field28E> getAll(SwiftTagListBlock block) {
        ArrayList<Field28E> result = new ArrayList<Field28E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("28E");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field28E(f));
            }
        }
        return result;
    }

    public static Field28E fromJson(String json) {
        Field28E field = new Field28E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("pageNumber") != null) {
            field.setComponent1(jsonObject.get("pageNumber").getAsString());
        }
        if (jsonObject.get("continuationIndicator") != null) {
            field.setComponent2(jsonObject.get("continuationIndicator").getAsString());
        }
        return field;
    }
}

