/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field29O
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "29O";
    public static final String F_29O = "29O";
    public static final Integer LOCATION = 1;
    public static final Integer START_TIME = 2;
    public static final Integer END_TIME = 3;

    public Field29O() {
        super(3);
    }

    public Field29O(String value) {
        super(value);
    }

    public Field29O(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"29O")) {
            throw new IllegalArgumentException("cannot create field 29O from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field29O newInstance(Field29O source) {
        Field29O cp = new Field29O();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("29O", value);
    }

    public static Tag emptyTag() {
        return new Tag("29O", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
            String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
            if (toparse != null) {
                if (toparse.length() >= 1) {
                    int endIndex = Math.min(4, toparse.length());
                    this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)endIndex));
                }
                if (toparse.length() > 4) {
                    this.setComponent3(StringUtils.substring((String)toparse, (int)4));
                }
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        SimpleDateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 29O");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        f = new SimpleDateFormat("HH:mm", this.notNull(locale));
        cal = this.getComponent3AsCalendar();
        if (cal != null) {
            return f.format(cal.getTime());
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SHH";
    }

    @Override
    public String parserPattern() {
        return "S/<HHMM><HHMM>";
    }

    @Override
    public String validatorPattern() {
        return "4!c/<HHMM><HHMM>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Location");
        result.add("Start Time");
        result.add("End Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "location");
        result.put(2, "startTime");
        result.put(3, "endTime");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("location", 1);
        this.labelMap.put("starttime", 2);
        this.labelMap.put("endtime", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getLocation() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getStartTime() {
        return this.getComponent2();
    }

    public Calendar getStartTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getEndTime() {
        return this.getComponent3();
    }

    public Calendar getEndTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public Field29O setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29O setLocation(String component1) {
        return this.setComponent1(component1);
    }

    public Field29O setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field29O setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field29O setStartTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field29O setStartTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field29O setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field29O setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field29O setEndTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field29O setEndTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getName() {
        return "29O";
    }

    public static Field29O get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("29O");
        if (t == null) {
            return null;
        }
        return new Field29O(t);
    }

    public static Field29O get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field29O.get(msg.getBlock4());
    }

    public static List<Field29O> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field29O.getAll(msg.getBlock4());
    }

    public static List<Field29O> getAll(SwiftTagListBlock block) {
        ArrayList<Field29O> result = new ArrayList<Field29O>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("29O");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field29O(f));
            }
        }
        return result;
    }

    public static Field29O fromJson(String json) {
        Field29O field = new Field29O();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("location") != null) {
            field.setComponent1(jsonObject.get("location").getAsString());
        }
        if (jsonObject.get("startTime") != null) {
            field.setComponent2(jsonObject.get("startTime").getAsString());
        }
        if (jsonObject.get("endTime") != null) {
            field.setComponent3(jsonObject.get("endTime").getAsString());
        }
        return field;
    }
}

