/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field37A
extends Field
implements Serializable,
AmountContainer,
DateContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37A";
    public static final String F_37A = "37A";
    public static final Integer RATE = 1;
    public static final Integer END_DATE = 2;
    public static final Integer PERIOD = 3;
    public static final Integer NUMBER = 4;
    public static final Integer INFORMATION = 5;

    public Field37A() {
        super(5);
    }

    public Field37A(String value) {
        super(value);
    }

    public Field37A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"37A")) {
            throw new IllegalArgumentException("cannot create field 37A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field37A newInstance(Field37A source) {
        Field37A cp = new Field37A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("37A", value);
    }

    public static Tag emptyTag() {
        return new Tag("37A", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        if (toparse != null) {
            if (toparse.length() >= 6) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)6));
            }
            if (toparse.length() >= 7) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)6, (int)7));
            }
            if (toparse.length() > 7) {
                String toparse2 = StringUtils.substring((String)toparse, (int)7);
                this.setComponent4(SwiftParseUtils.getTokenFirst(toparse2, "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse2, "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null || this.getComponent3() != null || this.getComponent4() != null) {
            result.append("//");
            this.append(result, 2);
            this.append(result, 3);
            this.append(result, 4);
        }
        if (this.getComponent5() != null) {
            result.append("/").append(this.getComponent5());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37A");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent1AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return this.getComponent(5);
    }

    @Override
    public String typesPattern() {
        return "IESNS";
    }

    @Override
    public String parserPattern() {
        return "N[//<DATE2>cS][/S]";
    }

    @Override
    public String validatorPattern() {
        return "<AMOUNT>12[//<DATE2><DM>3n][/16x]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rate");
        result.add("End Date");
        result.add("Period");
        result.add("Number");
        result.add("Information");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "rate");
        result.put(2, "endDate");
        result.put(3, "period");
        result.put(4, "number");
        result.put(5, "information");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("rate", 1);
        this.labelMap.put("enddate", 2);
        this.labelMap.put("date", 2);
        this.labelMap.put("period", 3);
        this.labelMap.put("dmmark", 3);
        this.labelMap.put("number", 4);
        this.labelMap.put("numberofdaysmonths", 4);
        this.labelMap.put("information", 5);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BigDecimal getComponent1AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(1));
    }

    public String getRate() {
        return this.getComponent1();
    }

    public BigDecimal getRateAsBigDecimal() {
        return this.getComponent1AsBigDecimal();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getEndDate() {
        return this.getComponent2();
    }

    public Calendar getEndDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getPeriod() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Long getComponent4AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(4));
    }

    public String getNumber() {
        return this.getComponent4();
    }

    public Long getNumberAsLong() {
        return this.getComponent4AsLong();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getInformation() {
        return this.getComponent5();
    }

    public Field37A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37A setComponent1(Number component1) {
        if (component1 instanceof BigDecimal) {
            this.setComponent(1, SwiftFormatUtils.getBigDecimal((BigDecimal)component1));
        } else if (component1 instanceof BigInteger) {
            this.setComponent(1, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component1)));
        } else if (component1 instanceof Long || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component1.longValue())));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component1.doubleValue())));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field37A setRate(String component1) {
        return this.setComponent1(component1);
    }

    public Field37A setRate(Number component1) {
        return this.setComponent1(component1);
    }

    public Field37A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37A setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field37A setEndDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field37A setEndDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field37A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37A setPeriod(String component3) {
        return this.setComponent3(component3);
    }

    public Field37A setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37A setComponent4(Number component4) {
        if (component4 instanceof Long) {
            this.setComponent(4, SwiftFormatUtils.getLong((Long)component4));
        } else if (component4 instanceof BigInteger || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field37A setNumber(String component4) {
        return this.setComponent4(component4);
    }

    public Field37A setNumber(Number component4) {
        return this.setComponent4(component4);
    }

    public Field37A setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field37A setInformation(String component5) {
        return this.setComponent5(component5);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "37A";
    }

    public static Field37A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37A");
        if (t == null) {
            return null;
        }
        return new Field37A(t);
    }

    public static Field37A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37A.get(msg.getBlock4());
    }

    public static List<Field37A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37A.getAll(msg.getBlock4());
    }

    public static List<Field37A> getAll(SwiftTagListBlock block) {
        ArrayList<Field37A> result = new ArrayList<Field37A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("37A");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field37A(f));
            }
        }
        return result;
    }

    public static Field37A fromJson(String json) {
        Field37A field = new Field37A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("rate") != null) {
            field.setComponent1(jsonObject.get("rate").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("endDate") != null) {
            field.setComponent2(jsonObject.get("endDate").getAsString());
        }
        if (jsonObject.get("dMMark") != null) {
            field.setComponent3(jsonObject.get("dMMark").getAsString());
        }
        if (jsonObject.get("period") != null) {
            field.setComponent3(jsonObject.get("period").getAsString());
        }
        if (jsonObject.get("numberofDaysMonths") != null) {
            field.setComponent4(jsonObject.get("numberofDaysMonths").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent4(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("information") != null) {
            field.setComponent5(jsonObject.get("information").getAsString());
        }
        return field;
    }
}

