/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field37H
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37H";
    public static final String F_37H = "37H";
    public static final Integer INDICATOR = 1;
    public static final Integer SIGN = 2;
    public static final Integer RATE = 3;

    public Field37H() {
        super(3);
    }

    public Field37H(String value) {
        super(value);
    }

    public Field37H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"37H")) {
            throw new IllegalArgumentException("cannot create field 37H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field37H newInstance(Field37H source) {
        Field37H cp = new Field37H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("37H", value);
    }

    public static Tag emptyTag() {
        return new Tag("37H", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        String toparse = SwiftParseUtils.getAlphaPrefix(value);
        if (toparse != null && toparse.length() > 1) {
            this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)(toparse.length() - 1)));
            this.setComponent2(StringUtils.substring((String)toparse, (int)(toparse.length() - 1)));
        } else {
            this.setComponent1(toparse);
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
        f.setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent3AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSI";
    }

    @Override
    public String parserPattern() {
        return "c[c]N";
    }

    @Override
    public String validatorPattern() {
        return "<DC>[<N>]<AMOUNT>12";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Indicator");
        result.add("Sign");
        result.add("Rate");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "indicator");
        result.put(2, "sign");
        result.put(3, "rate");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("indicator", 1);
        this.labelMap.put("dcmark", 1);
        this.labelMap.put("sign", 2);
        this.labelMap.put("rate", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getIndicator() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    public String getRate() {
        return this.getComponent3();
    }

    public BigDecimal getRateAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    public Field37H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37H setIndicator(String component1) {
        return this.setComponent1(component1);
    }

    public Field37H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37H setSign(String component2) {
        return this.setComponent2(component2);
    }

    public Field37H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37H setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field37H setRate(String component3) {
        return this.setComponent3(component3);
    }

    public Field37H setRate(Number component3) {
        return this.setComponent3(component3);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "37H";
    }

    public static Field37H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37H");
        if (t == null) {
            return null;
        }
        return new Field37H(t);
    }

    public static Field37H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37H.get(msg.getBlock4());
    }

    public static List<Field37H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37H.getAll(msg.getBlock4());
    }

    public static List<Field37H> getAll(SwiftTagListBlock block) {
        ArrayList<Field37H> result = new ArrayList<Field37H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("37H");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field37H(f));
            }
        }
        return result;
    }

    public static Field37H fromJson(String json) {
        Field37H field = new Field37H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("indicator") != null) {
            field.setComponent1(jsonObject.get("indicator").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("rate") != null) {
            field.setComponent3(jsonObject.get("rate").getAsString());
        }
        return field;
    }
}

