/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field49A
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "49A";
    public static final String F_49A = "49A";
    public static final Integer CODE = 1;
    public static final Integer NARRATIVE = 2;

    public Field49A() {
        super(2);
    }

    public Field49A(String value) {
        super(value);
    }

    public Field49A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"49A")) {
            throw new IllegalArgumentException("cannot create field 49A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field49A newInstance(Field49A source) {
        Field49A cp = new Field49A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("49A", value);
    }

    public static Tag emptyTag() {
        return new Tag("49A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            String[] lines = value.split("\\R", 2);
            if (lines != null && lines.length > 0) {
                this.setComponent1(lines[0]);
            }
            if (lines != null && lines.length > 1) {
                this.setComponent2(lines[1]);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 49A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S[$S]0-n";
    }

    @Override
    public String validatorPattern() {
        return "4!c(**)[$65z]0-50";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "narrative");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("code", 1);
        this.labelMap.put("instruction", 1);
        this.labelMap.put("narrative", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent2();
    }

    public Field49A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field49A setCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field49A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field49A setNarrative(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "49A";
    }

    public static Field49A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("49A");
        if (t == null) {
            return null;
        }
        return new Field49A(t);
    }

    public static Field49A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field49A.get(msg.getBlock4());
    }

    public static List<Field49A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field49A.getAll(msg.getBlock4());
    }

    public static List<Field49A> getAll(SwiftTagListBlock block) {
        ArrayList<Field49A> result = new ArrayList<Field49A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("49A");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field49A(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field49A cp = Field49A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field49A cp = Field49A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field49A cp = Field49A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field49A fromJson(String json) {
        Field49A field = new Field49A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("instruction") != null) {
            field.setComponent1(jsonObject.get("instruction").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

