/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field61
extends Field
implements Serializable,
AmountContainer,
DateContainer,
MultiLineField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "61";
    public static final String F_61 = "61";
    public static final Integer VALUE_DATE = 1;
    public static final Integer DATE = 1;
    public static final Integer ENTRY_DATE = 2;
    public static final Integer DEBITCREDIT_MARK = 3;
    public static final Integer FUNDS_CODE = 4;
    public static final Integer AMOUNT = 5;
    public static final Integer TRANSACTION_TYPE = 6;
    public static final Integer IDENTIFICATION_CODE = 7;
    public static final Integer REFERENCE_FOR_THE_ACCOUNT_OWNER = 8;
    public static final Integer REFERENCE_OF_THE_ACCOUNT_SERVICING_INSTITUTION = 9;
    public static final Integer SUPPLEMENTARY_DETAILS = 10;

    public Field61() {
        super(10);
    }

    public Field61(String value) {
        super(value);
    }

    public Field61(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"61")) {
            throw new IllegalArgumentException("cannot create field 61 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field61 newInstance(Field61 source) {
        Field61 cp = new Field61();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("61", value);
    }

    public static Tag emptyTag() {
        return new Tag("61", "");
    }

    @Override
    public void parse(String value) {
        this.init(10);
        this.parseCustom(value);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        this.append(result, 5);
        this.append(result, 6);
        this.append(result, 7);
        this.append(result, 8);
        if (this.getComponent9() != null) {
            result.append("//");
            result.append(this.getComponent9());
        }
        if (this.getComponent10() != null) {
            result.append("\r\n");
            result.append(this.getComponent10());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 10) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 61");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("MMM dd", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent5AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        if (component == 8) {
            return this.getComponent(8);
        }
        if (component == 9) {
            return this.getComponent(9);
        }
        return this.getComponent(10);
    }

    @Override
    public String typesPattern() {
        return "EJSSISSSSS";
    }

    @Override
    public String parserPattern() {
        return "CUSTOM";
    }

    @Override
    public String validatorPattern() {
        return "CUSTOM";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 9) {
            return true;
        }
        return component == 10;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 10;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Value Date");
        result.add("Entry Date");
        result.add("Debit/Credit Mark");
        result.add("Funds Code");
        result.add("Amount");
        result.add("Transaction Type");
        result.add("Identification Code");
        result.add("Reference For The Account Owner");
        result.add("Reference Of The Account Servicing Institution");
        result.add("Supplementary Details");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "valueDate");
        result.put(2, "entryDate");
        result.put(3, "debitCreditMark");
        result.put(4, "fundsCode");
        result.put(5, "amount");
        result.put(6, "transactionType");
        result.put(7, "identificationCode");
        result.put(8, "referenceForTheAccountOwner");
        result.put(9, "referenceOfTheAccountServicingInstitution");
        result.put(10, "supplementaryDetails");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("valuedate", 1);
        this.labelMap.put("date", 1);
        this.labelMap.put("entrydate", 2);
        this.labelMap.put("debitcreditmark", 3);
        this.labelMap.put("dcmark", 3);
        this.labelMap.put("fundscode", 4);
        this.labelMap.put("amount", 5);
        this.labelMap.put("transactiontype", 6);
        this.labelMap.put("identificationcode", 7);
        this.labelMap.put("referencefortheaccountowner", 8);
        this.labelMap.put("referenceoftheaccountservicinginstitution", 9);
        this.labelMap.put("supplementarydetails", 10);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getValueDate() {
        return this.getComponent1();
    }

    public String getDate() {
        return this.getValueDate();
    }

    public Calendar getValueDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public Calendar getDateAsCalendar() {
        return this.getValueDateAsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getMonthDay(this.getComponent(2));
    }

    public String getEntryDate() {
        return this.getComponent2();
    }

    public Calendar getEntryDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getDebitCreditMark() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getFundsCode() {
        return this.getComponent4();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public BigDecimal getComponent5AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent5();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent5AsBigDecimal();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getTransactionType() {
        return this.getComponent6();
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public String getIdentificationCode() {
        return this.getComponent7();
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public String getReferenceForTheAccountOwner() {
        return this.getComponent8();
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    public String getReferenceOfTheAccountServicingInstitution() {
        return this.getComponent9();
    }

    public String getComponent10() {
        return this.getComponent(10);
    }

    public String getSupplementaryDetails() {
        return this.getComponent10();
    }

    public Field61 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field61 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field61 setValueDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field61 setValueDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field61 setDate(String component1) {
        return this.setValueDate(component1);
    }

    public Field61 setDate(Calendar component1) {
        return this.setValueDate(component1);
    }

    public Field61 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field61 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getMonthDay(component2));
        return this;
    }

    public Field61 setEntryDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field61 setEntryDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field61 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field61 setDebitCreditMark(String component3) {
        return this.setComponent3(component3);
    }

    public Field61 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field61 setFundsCode(String component4) {
        return this.setComponent4(component4);
    }

    public Field61 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field61 setComponent5(Number component5) {
        if (component5 instanceof BigDecimal) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal((BigDecimal)component5));
        } else if (component5 instanceof BigInteger) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component5)));
        } else if (component5 instanceof Long || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.longValue())));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.doubleValue())));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field61 setAmount(String component5) {
        return this.setComponent5(component5);
    }

    public Field61 setAmount(Number component5) {
        return this.setComponent5(component5);
    }

    public Field61 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field61 setTransactionType(String component6) {
        return this.setComponent6(component6);
    }

    public Field61 setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field61 setIdentificationCode(String component7) {
        return this.setComponent7(component7);
    }

    public Field61 setComponent8(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field61 setReferenceForTheAccountOwner(String component8) {
        return this.setComponent8(component8);
    }

    public Field61 setComponent9(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field61 setReferenceOfTheAccountServicingInstitution(String component9) {
        return this.setComponent9(component9);
    }

    public Field61 setComponent10(String component10) {
        this.setComponent(10, component10);
        return this;
    }

    public Field61 setSupplementaryDetails(String component10) {
        return this.setComponent10(component10);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "61";
    }

    public static Field61 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("61");
        if (t == null) {
            return null;
        }
        return new Field61(t);
    }

    public static Field61 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field61.get(msg.getBlock4());
    }

    public static List<Field61> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field61.getAll(msg.getBlock4());
    }

    public static List<Field61> getAll(SwiftTagListBlock block) {
        ArrayList<Field61> result = new ArrayList<Field61>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("61");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field61(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field61 cp = Field61.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field61 cp = Field61.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field61 cp = Field61.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field61 fromJson(String json) {
        Field61 field = new Field61();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("valueDate") != null) {
            field.setComponent1(jsonObject.get("valueDate").getAsString());
        }
        if (jsonObject.get("entryDate") != null) {
            field.setComponent2(jsonObject.get("entryDate").getAsString());
        }
        if (jsonObject.get("dCMark") != null) {
            field.setComponent3(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("debitCreditMark") != null) {
            field.setComponent3(jsonObject.get("debitCreditMark").getAsString());
        }
        if (jsonObject.get("fundsCode") != null) {
            field.setComponent4(jsonObject.get("fundsCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent5(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("transactionType") != null) {
            field.setComponent6(jsonObject.get("transactionType").getAsString());
        }
        if (jsonObject.get("identificationCode") != null) {
            field.setComponent7(jsonObject.get("identificationCode").getAsString());
        }
        if (jsonObject.get("referenceForTheAccountOwner") != null) {
            field.setComponent8(jsonObject.get("referenceForTheAccountOwner").getAsString());
        }
        if (jsonObject.get("referenceOfTheAccountServicingInstitution") != null) {
            field.setComponent9(jsonObject.get("referenceOfTheAccountServicingInstitution").getAsString());
        }
        if (jsonObject.get("supplementaryDetails") != null) {
            field.setComponent10(jsonObject.get("supplementaryDetails").getAsString());
        }
        return field;
    }

    protected void parseCustom(String value) {
        int dates_length;
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        String dates = SwiftParseUtils.getNumericPrefix(lines.get(0));
        int n = dates_length = dates != null ? dates.length() : 0;
        if (dates_length >= 6) {
            this.setComponent1(StringUtils.substring((String)dates, (int)0, (int)6));
        }
        if (dates_length >= 10) {
            this.setComponent2(StringUtils.substring((String)dates, (int)6));
        }
        String toparse = StringUtils.substring((String)lines.get(0), (int)dates_length);
        String comp3and4 = null;
        if (toparse != null && toparse.length() > 0) {
            int i;
            for (i = 0; i < toparse.length() && !StringUtils.isNumeric((CharSequence)Character.toString(toparse.charAt(i))) && toparse.charAt(i) != ','; ++i) {
            }
            if (i > 0) {
                comp3and4 = StringUtils.substring((String)toparse, (int)0, (int)i);
            }
        }
        if (comp3and4 != null) {
            String toparse2;
            String comp5;
            if (comp3and4.charAt(0) == 'R' || comp3and4.charAt(0) == 'E') {
                if (comp3and4.length() >= 2) {
                    this.setComponent3(StringUtils.substring((String)comp3and4, (int)0, (int)2));
                }
                if (comp3and4.length() >= 3) {
                    this.setComponent4(StringUtils.substring((String)comp3and4, (int)2));
                }
            } else {
                if (comp3and4.length() >= 1) {
                    this.setComponent3(StringUtils.substring((String)comp3and4, (int)0, (int)1));
                }
                if (comp3and4.length() >= 2) {
                    this.setComponent4(StringUtils.substring((String)comp3and4, (int)1));
                }
            }
            int comp5_length = (comp5 = SwiftParseUtils.getNumericPrefix(toparse2 = StringUtils.substring((String)toparse, (int)comp3and4.length()))) != null ? comp5.length() : 0;
            this.setComponent5(comp5);
            String toparse3 = StringUtils.substring((String)toparse2, (int)comp5_length);
            String toParseTxnCode = StringUtils.substring((String)toparse3, (int)0, (int)4);
            this.setComponent6(StringUtils.substring((String)toParseTxnCode, (int)0, (int)1));
            this.setComponent7(StringUtils.substring((String)toParseTxnCode, (int)1));
            int toParseTxnCodeLength = toParseTxnCode != null ? toParseTxnCode.length() : 0;
            String toparse4 = StringUtils.substring((String)toparse3, (int)toParseTxnCodeLength);
            this.setComponent8(StringUtils.substringBefore((String)toparse4, (String)"//"));
            this.setComponent9(StringUtils.substringAfter((String)toparse4, (String)"//"));
        }
        if (lines.size() > 1) {
            this.setComponent10(lines.get(1));
        }
    }
}

