/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90D
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90D";
    public static final String F_90D = "90D";
    public static final Integer NUMBER = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;

    public Field90D() {
        super(3);
    }

    public Field90D(String value) {
        super(value);
    }

    public Field90D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90D")) {
            throw new IllegalArgumentException("cannot create field 90D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90D newInstance(Field90D source) {
        Field90D cp = new Field90D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90D", value);
    }

    public static Tag emptyTag() {
        return new Tag("90D", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getNumericPrefix(value));
        String toparse = SwiftParseUtils.getAlphaSuffix(value);
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
        f.setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent3AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "NCI";
    }

    @Override
    public String parserPattern() {
        return "NSN";
    }

    @Override
    public String validatorPattern() {
        return "5n<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "number");
        result.put(2, "currency");
        result.put(3, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("number", 1);
        this.labelMap.put("currency", 2);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getNumber() {
        return this.getComponent1();
    }

    public Long getNumberAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent2();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    public Field90D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90D setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field90D setNumber(String component1) {
        return this.setComponent1(component1);
    }

    public Field90D setNumber(Number component1) {
        return this.setComponent1(component1);
    }

    public Field90D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90D setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field90D setCurrency(String component2) {
        return this.setComponent2(component2);
    }

    public Field90D setCurrency(Currency component2) {
        return this.setComponent2(component2);
    }

    public Field90D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90D setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field90D setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field90D setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "90D";
    }

    public static Field90D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90D");
        if (t == null) {
            return null;
        }
        return new Field90D(t);
    }

    public static Field90D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90D.get(msg.getBlock4());
    }

    public static List<Field90D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90D.getAll(msg.getBlock4());
    }

    public static List<Field90D> getAll(SwiftTagListBlock block) {
        ArrayList<Field90D> result = new ArrayList<Field90D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("90D");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field90D(f));
            }
        }
        return result;
    }

    public static Field90D fromJson(String json) {
        Field90D field = new Field90D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("number") != null) {
            field.setComponent1(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

