/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field94F
extends Field
implements Serializable,
BICContainer,
GenericField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94F";
    public static final String F_94F = "94F";
    public static final Integer QUALIFIER = 1;
    public static final Integer PLACE_CODE = 2;
    public static final Integer IDENTIFIER_CODE = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field94F() {
        super(3);
    }

    public Field94F(String value) {
        super(value);
    }

    public Field94F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"94F")) {
            throw new IllegalArgumentException("cannot create field 94F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field94F newInstance(Field94F source) {
        Field94F cp = new Field94F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("94F", value);
    }

    public static Tag emptyTag() {
        return new Tag("94F", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return this.getComponent(3);
    }

    @Override
    public String typesPattern() {
        return "SSB";
    }

    @Override
    public String parserPattern() {
        return ":S//S/S";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//4!c/<BIC>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Place Code");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "placeCode");
        result.put(3, "identifierCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("placecode", 2);
        this.labelMap.put("code", 2);
        this.labelMap.put("identifiercode", 3);
        this.labelMap.put("bic", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPlaceCode() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BIC getComponent3AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public String getIdentifierCode() {
        return this.getComponent3();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent3AsBIC();
    }

    public Field94F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94F setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field94F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94F setPlaceCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field94F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field94F setComponent3(BIC component3) {
        this.setComponent(3, SwiftFormatUtils.getBIC(component3));
        return this;
    }

    public Field94F setIdentifierCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field94F setIdentifierCode(BIC component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "94F";
    }

    public static Field94F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94F");
        if (t == null) {
            return null;
        }
        return new Field94F(t);
    }

    public static Field94F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94F.get(msg.getBlock4());
    }

    public static List<Field94F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94F.getAll(msg.getBlock4());
    }

    public static List<Field94F> getAll(SwiftTagListBlock block) {
        ArrayList<Field94F> result = new ArrayList<Field94F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("94F");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field94F(f));
            }
        }
        return result;
    }

    public static Field94F fromJson(String json) {
        Field94F field = new Field94F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("placeCode") != null) {
            field.setComponent2(jsonObject.get("placeCode").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent3(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent3(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

