/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field102;
import com.prowidesoftware.swift.model.field.Field106;
import com.prowidesoftware.swift.model.field.Field107;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field175;
import com.prowidesoftware.swift.model.field.Field432;
import com.prowidesoftware.swift.model.field.Field619;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT019
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT019.class.getName());
    public static final String NAME = "019";

    public MT019(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT019(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT019 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT019(m);
    }

    public MT019() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT019(String sender, String receiver) {
        super(19, sender, receiver);
    }

    public MT019(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT019.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT019 object from FIN content with a Service Message. Check if the MT019 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT019 object from FIN content with message type " + param.getType());
        }
    }

    public static MT019 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT019(fin);
    }

    public MT019(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT019 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT019(stream);
    }

    public MT019(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT019 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT019(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT019 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT019 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT019 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT019 fromJson(String json) {
        return (MT019)AbstractMT.fromJson(json);
    }

    public Field175 getField175() {
        Tag t = this.tag("175");
        if (t != null) {
            return new Field175(t.getValue());
        }
        return null;
    }

    public Field106 getField106() {
        Tag t = this.tag("106");
        if (t != null) {
            return new Field106(t.getValue());
        }
        return null;
    }

    public Field108 getField108() {
        Tag t = this.tag("108");
        if (t != null) {
            return new Field108(t.getValue());
        }
        return null;
    }

    public Field102 getField102() {
        Tag t = this.tag("102");
        if (t != null) {
            return new Field102(t.getValue());
        }
        return null;
    }

    public Field107 getField107() {
        Tag t = this.tag("107");
        if (t != null) {
            return new Field107(t.getValue());
        }
        return null;
    }

    public Field432 getField432() {
        Tag t = this.tag("432");
        if (t != null) {
            return new Field432(t.getValue());
        }
        return null;
    }

    public Field619 getField619() {
        Tag t = this.tag("619");
        if (t != null) {
            return new Field619(t.getValue());
        }
        return null;
    }
}

