/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field206;
import com.prowidesoftware.swift.model.field.Field339;
import com.prowidesoftware.swift.model.field.Field344;
import com.prowidesoftware.swift.model.field.Field345;
import com.prowidesoftware.swift.model.field.Field346;
import com.prowidesoftware.swift.model.field.Field347;
import com.prowidesoftware.swift.model.field.Field348;
import com.prowidesoftware.swift.model.field.Field349;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT067
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT067.class.getName());
    public static final String NAME = "067";

    public MT067(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT067(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT067 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT067(m);
    }

    public MT067() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT067(String sender, String receiver) {
        super(67, sender, receiver);
    }

    public MT067(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT067.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT067 object from FIN content with a Service Message. Check if the MT067 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT067 object from FIN content with message type " + param.getType());
        }
    }

    public static MT067 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT067(fin);
    }

    public MT067(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT067 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT067(stream);
    }

    public MT067(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT067 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT067(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT067 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT067 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT067 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT067 fromJson(String json) {
        return (MT067)AbstractMT.fromJson(json);
    }

    public Field206 getField206() {
        Tag t = this.tag("206");
        if (t != null) {
            return new Field206(t.getValue());
        }
        return null;
    }

    public Field348 getField348() {
        Tag t = this.tag("348");
        if (t != null) {
            return new Field348(t.getValue());
        }
        return null;
    }

    public List<Field339> getField339() {
        ArrayList<Field339> result = new ArrayList<Field339>();
        Tag[] tags = this.tags("339");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field339(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field349> getField349() {
        ArrayList<Field349> result = new ArrayList<Field349>();
        Tag[] tags = this.tags("349");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field349(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field344> getField344() {
        ArrayList<Field344> result = new ArrayList<Field344>();
        Tag[] tags = this.tags("344");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field344(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field345> getField345() {
        ArrayList<Field345> result = new ArrayList<Field345>();
        Tag[] tags = this.tags("345");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field345(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field346> getField346() {
        ArrayList<Field346> result = new ArrayList<Field346>();
        Tag[] tags = this.tags("346");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field346(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field347> getField347() {
        ArrayList<Field347> result = new ArrayList<Field347>();
        Tag[] tags = this.tags("347");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field347(tag.getValue()));
            }
        }
        return result;
    }
}

