/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field17B;
import com.prowidesoftware.swift.model.field.Field19B;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field22H;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field36B;
import com.prowidesoftware.swift.model.field.Field36D;
import com.prowidesoftware.swift.model.field.Field70C;
import com.prowidesoftware.swift.model.field.Field95C;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field95S;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field97B;
import com.prowidesoftware.swift.model.field.Field97D;
import com.prowidesoftware.swift.model.field.Field97E;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98B;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT505
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT505.class.getName());
    public static final String NAME = "505";

    public MT505(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT505(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT505 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT505(m);
    }

    public MT505() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT505(String sender, String receiver) {
        super(505, sender, receiver);
    }

    public MT505(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT505.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT505 object from FIN content with a Service Message. Check if the MT505 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT505 object from FIN content with message type " + param.getType());
        }
    }

    public static MT505 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT505(fin);
    }

    public MT505(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT505 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT505(stream);
    }

    public MT505(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT505 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT505(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT505 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT505 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT505 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT505 fromJson(String json) {
        return (MT505)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98C getField98C() {
        Tag t = this.tag("98C");
        if (t != null) {
            return new Field98C(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field35B getField35B() {
        Tag t = this.tag("35B");
        if (t != null) {
            return new Field35B(t.getValue());
        }
        return null;
    }

    public Field36B getField36B() {
        Tag t = this.tag("36B");
        if (t != null) {
            return new Field36B(t.getValue());
        }
        return null;
    }

    public Field36D getField36D() {
        Tag t = this.tag("36D");
        if (t != null) {
            return new Field36D(t.getValue());
        }
        return null;
    }

    public Field17B getField17B() {
        Tag t = this.tag("17B");
        if (t != null) {
            return new Field17B(t.getValue());
        }
        return null;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70C> getField70C() {
        ArrayList<Field70C> result = new ArrayList<Field70C>();
        Tag[] tags = this.tags("70C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22H> getField22H() {
        ArrayList<Field22H> result = new ArrayList<Field22H>();
        Tag[] tags = this.tags("22H");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22H(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95C> getField95C() {
        ArrayList<Field95C> result = new ArrayList<Field95C>();
        Tag[] tags = this.tags("95C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95S> getField95S() {
        ArrayList<Field95S> result = new ArrayList<Field95S>();
        Tag[] tags = this.tags("95S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97A> getField97A() {
        ArrayList<Field97A> result = new ArrayList<Field97A>();
        Tag[] tags = this.tags("97A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97B> getField97B() {
        ArrayList<Field97B> result = new ArrayList<Field97B>();
        Tag[] tags = this.tags("97B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97D> getField97D() {
        ArrayList<Field97D> result = new ArrayList<Field97D>();
        Tag[] tags = this.tags("97D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97E> getField97E() {
        ArrayList<Field97E> result = new ArrayList<Field97E>();
        Tag[] tags = this.tags("97E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98B> getField98B() {
        ArrayList<Field98B> result = new ArrayList<Field98B>();
        Tag[] tags = this.tags("98B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field19B> getField19B() {
        ArrayList<Field19B> result = new ArrayList<Field19B>();
        Tag[] tags = this.tags("19B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field19B(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public SequenceA getSequenceGENL() {
        return this.getSequenceA();
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public static SequenceA getSequenceGENL(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceA(parentSequence);
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT505.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceA1> getSequenceAGREList() {
        return this.getSequenceA1List();
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("AGRE")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("AGRE").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceA1> getSequenceAGREList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceA1List(parentSequence);
    }

    public List<SequenceA2> getSequenceA2List() {
        return MT505.getSequenceA2List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceA2> getSequenceLINKList() {
        return this.getSequenceA2List();
    }

    public static List<SequenceA2> getSequenceA2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA2> result = new ArrayList<SequenceA2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA2 s = new SequenceA2();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceA2> getSequenceLINKList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceA2List(parentSequence);
    }

    public List<SequenceB> getSequenceBList() {
        return MT505.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB> getSequenceCOLDList() {
        return this.getSequenceBList();
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("COLD")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB s = new SequenceB();
                s.setTags(b.getSubBlock("COLD").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB> getSequenceCOLDList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceBList(parentSequence);
    }

    public List<SequenceB1> getSequenceB1List() {
        return MT505.getSequenceB1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB1> getSequenceSCOLList() {
        return this.getSequenceB1List();
    }

    public static List<SequenceB1> getSequenceB1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1> result = new ArrayList<SequenceB1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1 s = new SequenceB1();
                s.setTags(b.getSubBlock("SCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB1> getSequenceSCOLList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB1List(parentSequence);
    }

    public List<SequenceB1a> getSequenceB1aList() {
        return MT505.getSequenceB1aList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB1a> getSequenceSETDETList() {
        return this.getSequenceB1aList();
    }

    public static List<SequenceB1a> getSequenceB1aList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SETDET")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1a> result = new ArrayList<SequenceB1a>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1a s = new SequenceB1a();
                s.setTags(b.getSubBlock("SETDET").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB1a> getSequenceSETDETList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB1aList(parentSequence);
    }

    public List<SequenceB1a1> getSequenceB1a1List() {
        return MT505.getSequenceB1a1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB1a1> getSequenceSETPRTYList() {
        return this.getSequenceB1a1List();
    }

    public static List<SequenceB1a1> getSequenceB1a1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SETPRTY")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1a1> result = new ArrayList<SequenceB1a1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1a1 s = new SequenceB1a1();
                s.setTags(b.getSubBlock("SETPRTY").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB1a1> getSequenceSETPRTYList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB1a1List(parentSequence);
    }

    public List<SequenceB2> getSequenceB2List() {
        return MT505.getSequenceB2List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB2> getSequenceCCOLList() {
        return this.getSequenceB2List();
    }

    public static List<SequenceB2> getSequenceB2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB2> result = new ArrayList<SequenceB2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB2 s = new SequenceB2();
                s.setTags(b.getSubBlock("CCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB2> getSequenceCCOLList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB2List(parentSequence);
    }

    public List<SequenceB2a> getSequenceB2aList() {
        return MT505.getSequenceB2aList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB2a> getSequenceCASHSETList() {
        return this.getSequenceB2aList();
    }

    public static List<SequenceB2a> getSequenceB2aList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CASHSET")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB2a> result = new ArrayList<SequenceB2a>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB2a s = new SequenceB2a();
                s.setTags(b.getSubBlock("CASHSET").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB2a> getSequenceCASHSETList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB2aList(parentSequence);
    }

    public List<SequenceB2a1> getSequenceB2a1List() {
        return MT505.getSequenceB2a1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB2a1> getSequenceCSHPRTYList() {
        return this.getSequenceB2a1List();
    }

    public static List<SequenceB2a1> getSequenceB2a1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CSHPRTY")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB2a1> result = new ArrayList<SequenceB2a1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB2a1 s = new SequenceB2a1();
                s.setTags(b.getSubBlock("CSHPRTY").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB2a1> getSequenceCSHPRTYList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB2a1List(parentSequence);
    }

    public List<SequenceB3> getSequenceB3List() {
        return MT505.getSequenceB3List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB3> getSequenceBCOLList() {
        return this.getSequenceB3List();
    }

    public static List<SequenceB3> getSequenceB3List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("BCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB3> result = new ArrayList<SequenceB3>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB3 s = new SequenceB3();
                s.setTags(b.getSubBlock("BCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB3> getSequenceBCOLList(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceB3List(parentSequence);
    }

    public SequenceC getSequenceC() {
        return new SequenceC(super.getSwiftMessageNotNullOrException());
    }

    public SequenceC getSequenceSETDET1() {
        return this.getSequenceC();
    }

    public static SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        SequenceC s = new SequenceC();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("SETDET1").getTags());
        }
        return s;
    }

    public static SequenceC getSequenceSETDET1(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceC(parentSequence);
    }

    public List<SequenceC1> getSequenceC1List() {
        return MT505.getSequenceC1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceC1> getSequenceSETPRTY1List() {
        return this.getSequenceC1List();
    }

    public static List<SequenceC1> getSequenceC1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SETPRTY1")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC1> result = new ArrayList<SequenceC1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC1 s = new SequenceC1();
                s.setTags(b.getSubBlock("SETPRTY1").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceC1> getSequenceSETPRTY1List(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceC1List(parentSequence);
    }

    public SequenceD getSequenceD() {
        return new SequenceD(super.getSwiftMessageNotNullOrException());
    }

    public SequenceD getSequenceCASHSET1() {
        return this.getSequenceD();
    }

    public static SequenceD getSequenceD(SwiftTagListBlock parentSequence) {
        SequenceD s = new SequenceD();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("CASHSET1").getTags());
        }
        return s;
    }

    public static SequenceD getSequenceCASHSET1(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceD(parentSequence);
    }

    public List<SequenceD1> getSequenceD1List() {
        return MT505.getSequenceD1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceD1> getSequenceCSHPRTY1List() {
        return this.getSequenceD1List();
    }

    public static List<SequenceD1> getSequenceD1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CSHPRTY1")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceD1> result = new ArrayList<SequenceD1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceD1 s = new SequenceD1();
                s.setTags(b.getSubBlock("CSHPRTY1").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceD1> getSequenceCSHPRTY1List(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceD1List(parentSequence);
    }

    public SequenceE getSequenceE() {
        return new SequenceE(super.getSwiftMessageNotNullOrException());
    }

    public SequenceE getSequenceADDINFO() {
        return this.getSequenceE();
    }

    public static SequenceE getSequenceE(SwiftTagListBlock parentSequence) {
        SequenceE s = new SequenceE();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("ADDINFO").getTags());
        }
        return s;
    }

    public static SequenceE getSequenceADDINFO(SwiftTagListBlock parentSequence) {
        return MT505.getSequenceE(parentSequence);
    }

    public static class SequenceE
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ADDINFO";
        public static final Tag START_TAG = new Tag("16R", "ADDINFO");
        public static final Tag END_TAG = new Tag("16S", "ADDINFO");

        private SequenceE() {
            super(new ArrayList<Tag>());
        }

        private SequenceE(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceE newInstance(Tag ... tags) {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceE newInstance() {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceE newInstance(SwiftTagListBlock ... sequences) {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceE(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceD1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CSHPRTY1";
        public static final Tag START_TAG = new Tag("16R", "CSHPRTY1");
        public static final Tag END_TAG = new Tag("16S", "CSHPRTY1");

        private SequenceD1() {
            super(new ArrayList<Tag>());
        }

        private SequenceD1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD1 newInstance(Tag ... tags) {
            SequenceD1 result = new SequenceD1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceD1 newInstance() {
            SequenceD1 result = new SequenceD1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceD1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceD1 result = new SequenceD1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceD1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceD
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CASHSET1";
        public static final Tag START_TAG = new Tag("16R", "CASHSET1");
        public static final Tag END_TAG = new Tag("16S", "CASHSET1");

        private SequenceD() {
            super(new ArrayList<Tag>());
        }

        private SequenceD(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD newInstance(Tag ... tags) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance() {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance(SwiftTagListBlock ... sequences) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceD(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETPRTY1";
        public static final Tag START_TAG = new Tag("16R", "SETPRTY1");
        public static final Tag END_TAG = new Tag("16S", "SETPRTY1");

        private SequenceC1() {
            super(new ArrayList<Tag>());
        }

        private SequenceC1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC1 newInstance(Tag ... tags) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance() {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETDET1";
        public static final Tag START_TAG = new Tag("16R", "SETDET1");
        public static final Tag END_TAG = new Tag("16S", "SETDET1");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB3
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "BCOL";
        public static final Tag START_TAG = new Tag("16R", "BCOL");
        public static final Tag END_TAG = new Tag("16S", "BCOL");

        private SequenceB3() {
            super(new ArrayList<Tag>());
        }

        private SequenceB3(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB3 newInstance(Tag ... tags) {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB3 newInstance() {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB3 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB3(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB2a1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CSHPRTY";
        public static final Tag START_TAG = new Tag("16R", "CSHPRTY");
        public static final Tag END_TAG = new Tag("16S", "CSHPRTY");

        private SequenceB2a1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB2a1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB2a1 newInstance(Tag ... tags) {
            SequenceB2a1 result = new SequenceB2a1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2a1 newInstance() {
            SequenceB2a1 result = new SequenceB2a1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2a1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB2a1 result = new SequenceB2a1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB2a1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB2a
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CASHSET";
        public static final Tag START_TAG = new Tag("16R", "CASHSET");
        public static final Tag END_TAG = new Tag("16S", "CASHSET");

        private SequenceB2a() {
            super(new ArrayList<Tag>());
        }

        private SequenceB2a(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB2a newInstance(Tag ... tags) {
            SequenceB2a result = new SequenceB2a();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2a newInstance() {
            SequenceB2a result = new SequenceB2a();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2a newInstance(SwiftTagListBlock ... sequences) {
            SequenceB2a result = new SequenceB2a();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB2a(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CCOL";
        public static final Tag START_TAG = new Tag("16R", "CCOL");
        public static final Tag END_TAG = new Tag("16S", "CCOL");

        private SequenceB2() {
            super(new ArrayList<Tag>());
        }

        private SequenceB2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB2 newInstance(Tag ... tags) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance() {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1a1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETPRTY";
        public static final Tag START_TAG = new Tag("16R", "SETPRTY");
        public static final Tag END_TAG = new Tag("16S", "SETPRTY");

        private SequenceB1a1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1a1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1a1 newInstance(Tag ... tags) {
            SequenceB1a1 result = new SequenceB1a1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1a1 newInstance() {
            SequenceB1a1 result = new SequenceB1a1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1a1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1a1 result = new SequenceB1a1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1a1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1a
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETDET";
        public static final Tag START_TAG = new Tag("16R", "SETDET");
        public static final Tag END_TAG = new Tag("16S", "SETDET");

        private SequenceB1a() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1a(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1a newInstance(Tag ... tags) {
            SequenceB1a result = new SequenceB1a();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1a newInstance() {
            SequenceB1a result = new SequenceB1a();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1a newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1a result = new SequenceB1a();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1a(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SCOL";
        public static final Tag START_TAG = new Tag("16R", "SCOL");
        public static final Tag END_TAG = new Tag("16S", "SCOL");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "COLD";
        public static final Tag START_TAG = new Tag("16R", "COLD");
        public static final Tag END_TAG = new Tag("16S", "COLD");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA2() {
            super(new ArrayList<Tag>());
        }

        private SequenceA2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA2 newInstance(Tag ... tags) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance() {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "AGRE";
        public static final Tag START_TAG = new Tag("16R", "AGRE");
        public static final Tag END_TAG = new Tag("16S", "AGRE");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

