/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26E;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field45B;
import com.prowidesoftware.swift.model.field.Field46B;
import com.prowidesoftware.swift.model.field.Field47B;
import com.prowidesoftware.swift.model.field.Field49M;
import com.prowidesoftware.swift.model.field.Field49N;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT708
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT708.class.getName());
    public static final String NAME = "708";

    public MT708(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT708(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT708 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT708(m);
    }

    public MT708() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT708(String sender, String receiver) {
        super(708, sender, receiver);
    }

    public MT708(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT708.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT708 object from FIN content with a Service Message. Check if the MT708 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT708 object from FIN content with message type " + param.getType());
        }
    }

    public static MT708 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT708(fin);
    }

    public MT708(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT708 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT708(stream);
    }

    public MT708(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT708 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT708(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT708 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT708 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT708 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT708 fromJson(String json) {
        return (MT708)AbstractMT.fromJson(json);
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field26E getField26E() {
        Tag t = this.tag("26E");
        if (t != null) {
            return new Field26E(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field45B getField45B() {
        Tag t = this.tag("45B");
        if (t != null) {
            return new Field45B(t.getValue());
        }
        return null;
    }

    public Field46B getField46B() {
        Tag t = this.tag("46B");
        if (t != null) {
            return new Field46B(t.getValue());
        }
        return null;
    }

    public Field47B getField47B() {
        Tag t = this.tag("47B");
        if (t != null) {
            return new Field47B(t.getValue());
        }
        return null;
    }

    public Field49M getField49M() {
        Tag t = this.tag("49M");
        if (t != null) {
            return new Field49M(t.getValue());
        }
        return null;
    }

    public Field49N getField49N() {
        Tag t = this.tag("49N");
        if (t != null) {
            return new Field49N(t.getValue());
        }
        return null;
    }
}

