/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT799
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT799.class.getName());
    public static final String NAME = "799";

    public MT799(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT799(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT799 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT799(m);
    }

    public MT799() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT799(String sender, String receiver) {
        super(799, sender, receiver);
    }

    public MT799(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT799.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT799 object from FIN content with a Service Message. Check if the MT799 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT799 object from FIN content with message type " + param.getType());
        }
    }

    public static MT799 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT799(fin);
    }

    public MT799(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT799 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT799(stream);
    }

    public MT799(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT799 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT799(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT799 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT799 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT799 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT799 fromJson(String json) {
        return (MT799)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public List<Field79> getField79() {
        ArrayList<Field79> result = new ArrayList<Field79>();
        Tag[] tags = this.tags("79");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field79(tag.getValue()));
            }
        }
        return result;
    }
}

