/*
 * Decompiled with CFR 0.152.
 */
package com.pszymczyk.consul;

import com.pszymczyk.consul.ConsulPorts;
import com.pszymczyk.consul.ConsulProcess;
import com.pszymczyk.consul.EmbeddedConsulException;
import com.pszymczyk.consul.LogLevel;
import com.pszymczyk.consul.infrastructure.AntUnzip;
import com.pszymczyk.consul.infrastructure.ConsulWaiter;
import com.pszymczyk.consul.infrastructure.HttpBinaryRepository;
import com.pszymczyk.consul.infrastructure.OsResolver;
import groovy.json.JsonParserType;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.nio.file.Path;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulStarter
implements GroovyObject {
    private static final Logger logger;
    private final Path dataDir;
    private final Path downloadDir;
    private final Path configDir;
    private String customConfig;
    private final String consulVersion;
    private final LogLevel logLevel;
    private final ConsulPorts consulPorts;
    private final String advertise;
    private final String client;
    private boolean started;
    private HttpBinaryRepository binaryRepository;
    private AntUnzip unzip;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    ConsulStarter(Path path, Path path2, Path path3, String string, String string2, LogLevel logLevel, ConsulPorts.ConsulPortsBuilder consulPortsBuilder, String string3, String string4) {
        void client;
        void advertise;
        void ports;
        void consulVersion;
        void downloadDir;
        void dataDir;
        void customConfig;
        void configDir;
        void logLevel2;
        MetaClass metaClass;
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        this.started = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var13_13 = logLevel2;
        this.logLevel = (LogLevel)ShortTypeHandling.castToEnum((Object)var13_13, LogLevel.class);
        void var14_14 = configDir;
        this.configDir = (Path)ScriptBytecodeAdapter.castToType((Object)var14_14, Path.class);
        void var15_15 = customConfig;
        this.customConfig = ShortTypeHandling.castToString((Object)var15_15);
        void var16_16 = dataDir;
        this.dataDir = (Path)ScriptBytecodeAdapter.castToType((Object)var16_16, Path.class);
        void var17_17 = downloadDir;
        this.downloadDir = (Path)ScriptBytecodeAdapter.castToType((Object)var17_17, Path.class);
        void var18_18 = consulVersion;
        this.consulVersion = ShortTypeHandling.castToString((Object)var18_18);
        Object object = callSiteArray[0].callStatic(ConsulStarter.class, (Object)ports, (Object)customConfig);
        this.consulPorts = (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)object, ConsulPorts.class);
        void var20_20 = advertise;
        this.advertise = ShortTypeHandling.castToString((Object)var20_20);
        void var21_21 = client;
        this.client = ShortTypeHandling.castToString((Object)var21_21);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.makeDI();
        }
    }

    private static ConsulPorts mergePorts(ConsulPorts.ConsulPortsBuilder ports, String customConfig) {
        Object object;
        Object object2;
        Reference ports2 = new Reference((Object)ports);
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object extraPorts = null;
        extraPorts = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[2].callStatic(ConsulStarter.class, (Object)customConfig)) : (object = ConsulStarter.parseCustomConfig(customConfig));
        public class _mergePorts_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ports;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mergePorts_closure1(Object _outerInstance, Object _thisObject, Reference ports) {
                Reference reference;
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ports = reference = ports;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(it);
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"dns")) {
                    Object object2 = callSiteArray[1].call(this.ports.get(), callSiteArray[2].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object2, ConsulPorts.ConsulPortsBuilder.class)));
                    return object2;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"http")) {
                    Object object3 = callSiteArray[3].call(this.ports.get(), callSiteArray[4].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object3, ConsulPorts.ConsulPortsBuilder.class)));
                    return object3;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"rpc")) {
                    Object object4 = callSiteArray[5].call(this.ports.get(), callSiteArray[6].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object4, ConsulPorts.ConsulPortsBuilder.class)));
                    return object4;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_lan")) {
                    Object object5 = callSiteArray[7].call(this.ports.get(), callSiteArray[8].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object5, ConsulPorts.ConsulPortsBuilder.class)));
                    return object5;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_wan")) {
                    Object object6 = callSiteArray[9].call(this.ports.get(), callSiteArray[10].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object6, ConsulPorts.ConsulPortsBuilder.class)));
                    return object6;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"server")) {
                    Object object7 = callSiteArray[11].call(this.ports.get(), callSiteArray[12].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object7, ConsulPorts.ConsulPortsBuilder.class)));
                    return object7;
                }
                return null;
            }

            public ConsulPorts.ConsulPortsBuilder getPorts() {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                return (ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)this.ports.get(), ConsulPorts.ConsulPortsBuilder.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergePorts_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "withDnsPort";
                stringArray[2] = "value";
                stringArray[3] = "withHttpPort";
                stringArray[4] = "value";
                stringArray[5] = "withRpcPort";
                stringArray[6] = "value";
                stringArray[7] = "withSerfLanPort";
                stringArray[8] = "value";
                stringArray[9] = "withSerfWanPort";
                stringArray[10] = "value";
                stringArray[11] = "withServerPort";
                stringArray[12] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _mergePorts_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_mergePorts_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mergePorts_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[3].call(extraPorts, (Object)new _mergePorts_closure1(ConsulStarter.class, ConsulStarter.class, ports2));
        return (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)((ConsulPorts.ConsulPortsBuilder)ports2.get())), ConsulPorts.class);
    }

    private static Object parseCustomConfig(String customConfig) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)customConfig, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)customConfig))) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        Object parser = callSiteArray[6].call(callSiteArray[7].callConstructor(JsonSlurper.class), callSiteArray[8].callGetProperty(JsonParserType.class));
        return callSiteArray[9].call(callSiteArray[10].call(parser, (Object)customConfig), (Object)"ports");
    }

    private void makeDI() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object object = callSiteArray[11].callConstructor(HttpBinaryRepository.class);
        this.binaryRepository = (HttpBinaryRepository)ScriptBytecodeAdapter.castToType((Object)object, HttpBinaryRepository.class);
        Object object2 = callSiteArray[12].callConstructor(AntUnzip.class);
        this.unzip = (AntUnzip)ScriptBytecodeAdapter.castToType((Object)object2, AntUnzip.class);
    }

    public ConsulProcess start() {
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        callSiteArray[13].call((Object)logger, (Object)"Starting new Consul process.");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[14].callCurrent((GroovyObject)this);
        } else {
            this.checkInitialState();
        }
        this.started = bl = true;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callCurrent((GroovyObject)this))) {
                callSiteArray[16].callCurrent((GroovyObject)this);
            }
        } else if (!this.isBinaryDownloaded()) {
            this.downloadAndUnpackBinary();
        }
        callSiteArray[17].callCurrent((GroovyObject)this, (Object)this.consulPorts);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.customConfig, null)) {
                callSiteArray[18].callCurrent((GroovyObject)this);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)this.customConfig, null)) {
            this.createExtraConfigFile();
        }
        String downloadDirAsString = ShortTypeHandling.castToString((Object)callSiteArray[19].call(callSiteArray[20].call((Object)this.downloadDir)));
        String pathToConsul = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)"windows", (Object)callSiteArray[21].call(OsResolver.class))) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul.exe"});
            pathToConsul = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String[] command = new String[]{pathToConsul, "agent", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataDir}, new String[]{"-data-dir=", ""})), "-dev", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.configDir}, new String[]{"-config-dir=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.advertise}, new String[]{"-advertise=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.client}, new String[]{"-client=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[22].callGetProperty((Object)this.logLevel)}, new String[]{"-log-level=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[23].callGetProperty((Object)this.consulPorts)}, new String[]{"-http-port=", ""}))};
        ConsulProcess process = (ConsulProcess)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callConstructor(ConsulProcess.class, (Object)this.dataDir, (Object)this.consulPorts, callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].callConstructor(ProcessBuilder.class), callSiteArray[30].call((Object)this.downloadDir)), (Object)command)))), ConsulProcess.class);
        callSiteArray[31].call((Object)logger, (Object)"Starting Consul process on port {}", callSiteArray[32].callGetProperty((Object)this.consulPorts));
        callSiteArray[33].call(callSiteArray[34].callConstructor(ConsulWaiter.class, callSiteArray[35].callGetProperty((Object)this.consulPorts)));
        callSiteArray[36].call((Object)logger, (Object)"Consul process started");
        return process;
    }

    private void checkInitialState() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (this.started) {
            throw (Throwable)callSiteArray[37].callConstructor(EmbeddedConsulException.class, (Object)"This Consul Starter instance already started Consul process. Create new ConsulStarter instance");
        }
        try {
            public class _checkInitialState_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _checkInitialState_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    throw (Throwable)callSiteArray[0].callConstructor(EmbeddedConsulException.class, (Object)new GStringImpl(new Object[]{callSiteArray[1].callGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)this))}, new String[]{"Port ", " is not available, cannot start Consul process."}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkInitialState_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "httpPort";
                    stringArray[2] = "consulPorts";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _checkInitialState_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_checkInitialState_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _checkInitialState_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[38].call(IOGroovyMethods.class, callSiteArray[39].callConstructor(Socket.class, (Object)"localhost", callSiteArray[40].callGetProperty((Object)this.consulPorts)), (Object)new _checkInitialState_closure2(this, this));
        }
        catch (IOException ex) {
        }
    }

    private void downloadAndUnpackBinary() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callConstructor(File.class, callSiteArray[42].call(callSiteArray[43].call((Object)this.downloadDir)), (Object)"consul.zip"), File.class);
        callSiteArray[44].call((Object)logger, (Object)"Downloading archives into: {}", callSiteArray[45].call((Object)file));
        File archive = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)this.binaryRepository, (Object)this.consulVersion, (Object)file), File.class);
        callSiteArray[47].call((Object)logger, (Object)"Unzipping binaries into: {}", callSiteArray[48].call((Object)this.downloadDir));
        callSiteArray[49].call((Object)this.unzip, (Object)archive, callSiteArray[50].call((Object)this.downloadDir));
    }

    private void createBasicConfigFile(ConsulPorts consulPorts) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File portsConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(File.class, callSiteArray[52].call((Object)this.configDir), (Object)"basic_config.json"), File.class);
        callSiteArray[53].call((Object)logger, (Object)"Creating ports configuration file: {}", callSiteArray[54].call((Object)portsConfigFile));
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[55].callGetProperty((Object)consulPorts), callSiteArray[56].callGetProperty((Object)consulPorts), callSiteArray[57].callGetProperty((Object)consulPorts), callSiteArray[58].callGetProperty((Object)consulPorts), callSiteArray[59].callGetProperty((Object)consulPorts)}, new String[]{"\n            {\n                \"ports\": {\n                    \"dns\": ", ",\n                    \"rpc\": ", ",\n                    \"serf_lan\": ", ",\n                    \"serf_wan\": ", ",\n                    \"server\": ", "\n                },\n                \"disable_update_check\": true,\n                \"performance\": {\n                    \"raft_multiplier\": 1\n                }\n            }\n        "});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)portsConfigFile, (String)"text");
    }

    private void createExtraConfigFile() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File customConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(File.class, callSiteArray[61].call((Object)this.configDir), (Object)"extra_config.json"), File.class);
        callSiteArray[62].call((Object)logger, (Object)"Creating custom configuration file: {}", callSiteArray[63].call((Object)customConfigFile));
        String string = this.customConfig;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)customConfigFile, (String)"text");
    }

    private boolean isBinaryDownloaded() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(callSiteArray[65].callConstructor(File.class, callSiteArray[66].call((Object)this.downloadDir), (Object)"consul")));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConsulStarter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ConsulStarter.$getCallSiteArray()[67].call(LoggerFactory.class, ConsulStarter.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "mergePorts";
        stringArray[1] = "makeDI";
        stringArray[2] = "parseCustomConfig";
        stringArray[3] = "collect";
        stringArray[4] = "build";
        stringArray[5] = "isEmpty";
        stringArray[6] = "setType";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "LAX";
        stringArray[9] = "getAt";
        stringArray[10] = "parseText";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "info";
        stringArray[14] = "checkInitialState";
        stringArray[15] = "isBinaryDownloaded";
        stringArray[16] = "downloadAndUnpackBinary";
        stringArray[17] = "createBasicConfigFile";
        stringArray[18] = "createExtraConfigFile";
        stringArray[19] = "toString";
        stringArray[20] = "toAbsolutePath";
        stringArray[21] = "resolve";
        stringArray[22] = "value";
        stringArray[23] = "httpPort";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "start";
        stringArray[26] = "inheritIO";
        stringArray[27] = "command";
        stringArray[28] = "directory";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "toFile";
        stringArray[31] = "info";
        stringArray[32] = "httpPort";
        stringArray[33] = "awaitUntilConsulStarted";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "httpPort";
        stringArray[36] = "info";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "withCloseable";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "httpPort";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "toString";
        stringArray[43] = "toAbsolutePath";
        stringArray[44] = "info";
        stringArray[45] = "toString";
        stringArray[46] = "getConsulBinaryArchive";
        stringArray[47] = "info";
        stringArray[48] = "toString";
        stringArray[49] = "unzip";
        stringArray[50] = "toFile";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "toFile";
        stringArray[53] = "info";
        stringArray[54] = "toString";
        stringArray[55] = "dnsPort";
        stringArray[56] = "rpcPort";
        stringArray[57] = "serfLanPort";
        stringArray[58] = "serfWanPort";
        stringArray[59] = "serverPort";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "toFile";
        stringArray[62] = "info";
        stringArray[63] = "toString";
        stringArray[64] = "exists";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "toString";
        stringArray[67] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[68];
        ConsulStarter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConsulStarter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConsulStarter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

