/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.HistoryInterface;
import com.pubnub.internal.extension.JsonElementKt;
import com.pubnub.internal.managers.MapperManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00012BO\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0#H\u0002J\u0016\u0010$\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0014J2\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0)j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`*H\u0014J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,H\u0014J\b\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020!H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0011\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0010\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001f\u0010\u0019\u00a8\u00063"}, d2={"Lcom/pubnub/internal/endpoints/HistoryEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNHistoryResult;", "Lcom/pubnub/internal/endpoints/HistoryInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channel", "", "start", "", "end", "count", "", "reverse", "", "includeTimetoken", "includeMeta", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;IZZZ)V", "getChannel", "()Ljava/lang/String;", "getCount", "()I", "countParam", "getEnd", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIncludeMeta", "()Z", "getIncludeTimetoken", "getReverse", "getStart", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHistoryOperation;", "validateParams", "Companion", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nHistoryEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryEndpoint.kt\ncom/pubnub/internal/endpoints/HistoryEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class HistoryEndpoint
extends EndpointCore<JsonElement, PNHistoryResult>
implements HistoryInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String channel;
    @Nullable
    private final Long start;
    @Nullable
    private final Long end;
    private final int count;
    private final boolean reverse;
    private final boolean includeTimetoken;
    private final boolean includeMeta;
    private final int countParam;
    public static final int MAX_COUNT = 100;

    public HistoryEndpoint(@NotNull PubNubCore pubnub, @NotNull String channel, @Nullable Long start, @Nullable Long end, int count, boolean reverse, boolean includeTimetoken, boolean includeMeta) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.start = start;
        this.end = end;
        this.count = count;
        this.reverse = reverse;
        this.includeTimetoken = includeTimetoken;
        this.includeMeta = includeMeta;
        int n = this.getCount();
        this.countParam = (1 <= n ? n < 101 : false) ? this.getCount() : 100;
    }

    public /* synthetic */ HistoryEndpoint(PubNubCore pubNubCore, String string, Long l, Long l2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        this(pubNubCore, string, l, l2, n, bl, bl2, bl3);
    }

    @Override
    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public Long getStart() {
        return this.start;
    }

    @Override
    @Nullable
    public Long getEnd() {
        return this.end;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean getReverse() {
        return this.reverse;
    }

    @Override
    public boolean getIncludeTimetoken() {
        return this.includeTimetoken;
    }

    @Override
    public boolean getIncludeMeta() {
        return this.includeMeta;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getHistoryService$pubnub_core_impl().fetchHistory(this.getConfiguration().getSubscribeKey(), this.getChannel(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHistoryResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        MapperManager mapperManager = this.getPubnub().getMapper();
        MapperManager mapperManager2 = this.getPubnub().getMapper();
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        JsonElement jsonElement = mapperManager2.getArrayElement((JsonElement)object, 1);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"pubnub.mapper.getArrayElement(input.body()!!, 1)");
        long startTimeToken = mapperManager.elementToLong(jsonElement);
        MapperManager mapperManager3 = this.getPubnub().getMapper();
        MapperManager mapperManager4 = this.getPubnub().getMapper();
        Object object2 = input.body();
        Intrinsics.checkNotNull((Object)object2);
        JsonElement jsonElement2 = mapperManager4.getArrayElement((JsonElement)object2, 2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"pubnub.mapper.getArrayElement(input.body()!!, 2)");
        long endTimeToken = mapperManager3.elementToLong(jsonElement2);
        List messages = new ArrayList();
        PNHistoryResult historyData = new PNHistoryResult(messages, startTimeToken, endTimeToken);
        MapperManager mapperManager5 = this.getPubnub().getMapper();
        Object object3 = input.body();
        Intrinsics.checkNotNull((Object)object3);
        if (mapperManager5.getArrayElement((JsonElement)object3, 0).isJsonArray()) {
            MapperManager mapperManager6 = this.getPubnub().getMapper();
            MapperManager mapperManager7 = this.getPubnub().getMapper();
            Object object4 = input.body();
            Intrinsics.checkNotNull((Object)object4);
            Iterator<JsonElement> iterator = mapperManager6.getArrayIterator(mapperManager7.getArrayElement((JsonElement)object4, 0));
            Intrinsics.checkNotNull(iterator);
            Iterator<JsonElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement historyEntry = iterator2.next();
                Long timetoken = null;
                JsonElement meta = null;
                Pair<JsonElement, PubNubError> historyMessageWithError = null;
                if (this.getIncludeTimetoken() || this.getIncludeMeta()) {
                    JsonElement jsonElement3 = this.getPubnub().getMapper().getField(historyEntry, "message");
                    Intrinsics.checkNotNull((Object)jsonElement3);
                    historyMessageWithError = JsonElementKt.tryDecryptMessage(jsonElement3, this.getConfiguration().getCryptoModule(), this.getPubnub().getMapper());
                    if (this.getIncludeTimetoken()) {
                        MapperManager mapperManager8 = this.getPubnub().getMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)historyEntry, (String)"historyEntry");
                        timetoken = mapperManager8.elementToLong(historyEntry, "timetoken");
                    }
                    if (this.getIncludeMeta()) {
                        meta = this.getPubnub().getMapper().getField(historyEntry, "meta");
                    }
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)historyEntry, (String)"historyEntry");
                    historyMessageWithError = JsonElementKt.tryDecryptMessage(historyEntry, this.getConfiguration().getCryptoModule(), this.getPubnub().getMapper());
                }
                JsonElement message = (JsonElement)historyMessageWithError.getFirst();
                PubNubError error = (PubNubError)historyMessageWithError.getSecond();
                PNHistoryItemResult historyItem = new PNHistoryItemResult(message, timetoken, meta, error);
                messages.add(historyItem);
            }
        } else {
            PubNubError pubNubError = PubNubError.HTTP_ERROR;
            throw new PubNubException("History is disabled", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return historyData;
    }

    @NotNull
    public PNOperationType.PNHistoryOperation operationType() {
        return PNOperationType.PNHistoryOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            String string;
            String string2;
            Map<String, String> map;
            queryParams.put("reverse", String.valueOf(this.getReverse()));
            queryParams.put("include_token", String.valueOf(this.getIncludeTimetoken()));
            queryParams.put("include_meta", String.valueOf(this.getIncludeMeta()));
            queryParams.put("count", String.valueOf(this.countParam));
            Long l = this.getStart();
            if (l != null) {
                long $this$addQueryParams_u24lambda_u240 = ((Number)l).longValue();
                boolean bl = false;
                map = queryParams;
                string2 = "start";
                string = String.valueOf($this$addQueryParams_u24lambda_u240);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string3;
                map.put(string2, string);
            }
            Long l2 = this.getEnd();
            if (l2 == null) break block1;
            long $this$addQueryParams_u24lambda_u241 = ((Number)l2).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "end";
            string = String.valueOf($this$addQueryParams_u24lambda_u241);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            string = string4;
            map.put(string2, string);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/internal/endpoints/HistoryEndpoint$Companion;", "", "()V", "MAX_COUNT", "", "pubnub-core-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

