/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.access.GrantTokenInterface;
import com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenRequestBody;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BS\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0014J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001dj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f`\u001eH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0014R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/pubnub/internal/endpoints/access/GrantTokenEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/access_manager/v3/GrantTokenResponse;", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNGrantTokenResult;", "Lcom/pubnub/internal/endpoints/access/GrantTokenInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "ttl", "", "meta", "", "authorizedUUID", "", "channels", "", "Lcom/pubnub/internal/models/consumer/access_manager/v3/ChannelGrant;", "channelGroups", "Lcom/pubnub/internal/models/consumer/access_manager/v3/ChannelGroupGrant;", "uuids", "Lcom/pubnub/internal/models/consumer/access_manager/v3/UUIDGrant;", "(Lcom/pubnub/internal/PubNubCore;ILjava/lang/Object;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getTtl", "()I", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nGrantTokenEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1549#2:77\n1620#2,3:78\n1#3:81\n*S KotlinDebug\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n*L\n28#1:73\n28#1:74,3\n30#1:77\n30#1:78,3\n*E\n"})
public final class GrantTokenEndpoint
extends EndpointCore<GrantTokenResponse, PNGrantTokenResult>
implements GrantTokenInterface {
    private final int ttl;
    @Nullable
    private final Object meta;
    @Nullable
    private final String authorizedUUID;
    @NotNull
    private final List<ChannelGrant> channels;
    @NotNull
    private final List<ChannelGroupGrant> channelGroups;
    @NotNull
    private final List<UUIDGrant> uuids;

    public GrantTokenEndpoint(@NotNull PubNubCore pubnub, int ttl, @Nullable Object meta, @Nullable String authorizedUUID, @NotNull List<? extends ChannelGrant> channels, @NotNull List<? extends ChannelGroupGrant> channelGroups, @NotNull List<? extends UUIDGrant> uuids) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        super(pubnub);
        this.ttl = ttl;
        this.meta = meta;
        this.authorizedUUID = authorizedUUID;
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuids = uuids;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGrant channelGrant = (ChannelGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channelGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGroupGrant channelGroupGrant = (ChannelGroupGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void validateParams() {
        if (!BasePNConfiguration.Companion.isValid(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING);
        }
        if (!BasePNConfiguration.Companion.isValid(this.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING);
        }
        if (CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.channels, (Iterable)this.channelGroups), (Iterable)this.uuids).isEmpty()) {
            PubNubError pubNubError = PubNubError.RESOURCES_MISSING;
            throw new PubNubException("At least one grant required", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    @Override
    @NotNull
    protected Call<GrantTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        GrantTokenRequestBody requestBody = GrantTokenRequestBody.Companion.of(this.getTtl(), this.channels, this.channelGroups, this.uuids, this.meta, this.authorizedUUID);
        return this.getRetrofitManager().getAccessManagerService$pubnub_core_impl().grantToken(this.getConfiguration().getSubscribeKey(), requestBody, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGrantTokenResult createResponse(@NotNull Response<GrantTokenResponse> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        String it = ((GrantTokenResponse)object).getData().getToken();
        boolean bl = false;
        return new PNGrantTokenResult(it);
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.PNAccessManagerGrantToken;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }
}

