/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.eventengine;

import com.pubnub.internal.eventengine.EffectInvocation;
import com.pubnub.internal.eventengine.Event;
import com.pubnub.internal.eventengine.Sink;
import com.pubnub.internal.eventengine.Source;
import com.pubnub.internal.eventengine.State;
import com.pubnub.internal.eventengine.TransitionKt;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u001a\b\u0002\u0010\u0005*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u00062\u00020\u0007B3\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0006\u0010\f\u001a\u00028\u0002\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015R\u0010\u0010\f\u001a\u00028\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pubnub/internal/eventengine/EventEngine;", "Ei", "Lcom/pubnub/internal/eventengine/EffectInvocation;", "Ev", "Lcom/pubnub/internal/eventengine/Event;", "S", "Lcom/pubnub/internal/eventengine/State;", "", "effectSink", "Lcom/pubnub/internal/eventengine/Sink;", "eventSource", "Lcom/pubnub/internal/eventengine/Source;", "currentState", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/pubnub/internal/eventengine/Sink;Lcom/pubnub/internal/eventengine/Source;Lcom/pubnub/internal/eventengine/State;Ljava/util/concurrent/ExecutorService;)V", "Lcom/pubnub/internal/eventengine/State;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "performTransitionAndEmitEffects", "", "event", "performTransitionAndEmitEffects$pubnub_core_impl", "(Lcom/pubnub/internal/eventengine/Event;)V", "start", "stop", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nEventEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventEngine.kt\ncom/pubnub/internal/eventengine/EventEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2,2:44\n*S KotlinDebug\n*F\n+ 1 EventEngine.kt\ncom/pubnub/internal/eventengine/EventEngine\n*L\n40#1:44,2\n*E\n"})
public final class EventEngine<Ei extends EffectInvocation, Ev extends Event, S extends State<Ei, Ev, S>> {
    @NotNull
    private final Sink<Ei> effectSink;
    @NotNull
    private final Source<Ev> eventSource;
    @NotNull
    private S currentState;
    @NotNull
    private final ExecutorService executorService;
    private final Logger log;

    public EventEngine(@NotNull Sink<Ei> effectSink, @NotNull Source<Ev> eventSource, @NotNull S currentState, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(effectSink, (String)"effectSink");
        Intrinsics.checkNotNullParameter(eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter(currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.effectSink = effectSink;
        this.eventSource = eventSource;
        this.currentState = currentState;
        this.executorService = executorService;
        this.log = LoggerFactory.getLogger(EventEngine.class);
    }

    public /* synthetic */ EventEngine(Sink sink, Source source, State state, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(sink, source, state, executorService);
    }

    public final void start() {
        this.executorService.submit(() -> EventEngine.start$lambda$0(this));
    }

    public final void stop() {
        this.executorService.shutdownNow();
    }

    public final void performTransitionAndEmitEffects$pubnub_core_impl(@NotNull Ev event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        StringBuilder stringBuilder = new StringBuilder().append("Current state is: ").append(Reflection.getOrCreateKotlinClass(this.currentState.getClass()).getSimpleName()).append(" ; ");
        String string = event.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event::class.java.name");
        this.log.trace(stringBuilder.append(StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null), (char)'$', null, (int)2, null)).append(" to be handled is: ").append(event).append(' ').toString());
        Pair pair = TransitionKt.transition(this.currentState, event);
        State newState = (State)pair.component1();
        Set invocations = (Set)pair.component2();
        this.currentState = newState;
        Iterable $this$forEach$iv = invocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EffectInvocation invocation = (EffectInvocation)element$iv;
            boolean bl = false;
            this.effectSink.add(invocation);
        }
    }

    private static final void start$lambda$0(EventEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            while (true) {
                Event event = (Event)this$0.eventSource.take();
                this$0.performTransitionAndEmitEffects$pubnub_core_impl(event);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

