/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtil;
import com.pubnub.internal.PubNubUtilKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0011\u001a\u00020\u00122\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0014j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0015H\u0002J\u001b\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0014j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0015H\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0014R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006#"}, d2={"Lcom/pubnub/internal/endpoints/presence/LeaveEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "(Lcom/pubnub/internal/PubNubCore;)V", "channelGroups", "", "", "getChannelGroups", "()Ljava/util/List;", "setChannelGroups", "(Ljava/util/List;)V", "channels", "getChannels", "setChannels", "addQueryParams", "", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "(Lretrofit2/Response;)Ljava/lang/Boolean;", "doWork", "Lretrofit2/Call;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNUnsubscribeOperation;", "validateParams", "pubnub-core-impl"})
public final class LeaveEndpoint
extends EndpointCore<Void, Boolean> {
    @NotNull
    private List<String> channels;
    @NotNull
    private List<String> channelGroups;

    public LeaveEndpoint(@NotNull PubNubCore pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        super(pubnub);
        this.channels = CollectionsKt.emptyList();
        this.channelGroups = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    public final void setChannels(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channels = list;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public final void setChannelGroups(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelGroups = list;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams(queryParams);
        return this.getRetrofitManager().getPresenceService$pubnub_core_impl().leave(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
    }

    private final void addQueryParams(HashMap<String, String> queryParams) {
        ((Map)queryParams).put("channel-group", PubNubUtilKt.toCsv(this.channelGroups));
        PubNubUtil.INSTANCE.maybeAddEeQueryParam$pubnub_core_impl((Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected Boolean createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return true;
    }

    @NotNull
    public PNOperationType.PNUnsubscribeOperation operationType() {
        return PNOperationType.PNUnsubscribeOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }
}

