/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNubError;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.PubSubResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtil;
import com.pubnub.internal.extension.JsonElementKt;
import com.pubnub.internal.managers.DuplicationManager;
import com.pubnub.internal.models.consumer.pubsub.objects.PNObjectEventMessage;
import com.pubnub.internal.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.internal.models.server.PresenceEnvelope;
import com.pubnub.internal.models.server.PublishMetaData;
import com.pubnub.internal.models.server.SubscribeMessage;
import com.pubnub.internal.models.server.files.FileUploadNotification;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J*\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pubnub/internal/workers/SubscribeMessageProcessor;", "", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "duplicationManager", "Lcom/pubnub/internal/managers/DuplicationManager;", "(Lcom/pubnub/internal/PubNubCore;Lcom/pubnub/internal/managers/DuplicationManager;)V", "formatFriendlyGetFileUrl", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildFileUrl", "channel", "fileId", "fileName", "generateSignature", "configuration", "Lcom/pubnub/api/v2/BasePNConfiguration;", "url", "authKey", "timestamp", "", "getDelta", "", "delta", "Lcom/google/gson/JsonElement;", "processIncomingPayload", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "message", "Lcom/pubnub/internal/models/server/SubscribeMessage;", "Companion", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nSubscribeMessageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscribeMessageProcessor.kt\ncom/pubnub/internal/workers/SubscribeMessageProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n1855#3,2:253\n*S KotlinDebug\n*F\n+ 1 SubscribeMessageProcessor.kt\ncom/pubnub/internal/workers/SubscribeMessageProcessor\n*L\n242#1:253,2\n*E\n"})
public final class SubscribeMessageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PubNubCore pubnub;
    @NotNull
    private final DuplicationManager duplicationManager;
    private final Logger log;
    @NotNull
    private final String formatFriendlyGetFileUrl;
    public static final int TYPE_MESSAGE = 0;
    public static final int TYPE_SIGNAL = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_MESSAGE_ACTION = 3;
    public static final int TYPE_FILES = 4;

    public SubscribeMessageProcessor(@NotNull PubNubCore pubnub, @NotNull DuplicationManager duplicationManager) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)duplicationManager, (String)"duplicationManager");
        this.pubnub = pubnub;
        this.duplicationManager = duplicationManager;
        this.log = LoggerFactory.getLogger((String)"SubscribeMessageProcessor");
        CharSequence charSequence = "/v1/files/{subKey}/channels/{channel}/files/{fileId}/{fileName}";
        Regex regex = new Regex("\\{.*?\\}");
        String string = "%s";
        this.formatFriendlyGetFileUrl = "%s" + regex.replace(charSequence, string);
    }

    @Nullable
    public final PNEvent processIncomingPayload(@NotNull SubscribeMessage message) {
        PNEvent pNEvent;
        block14: {
            block19: {
                Object object;
                Long l;
                String string;
                PNDownloadableFile pNDownloadableFile;
                Object object2;
                String string2;
                PubNubError error;
                block21: {
                    block20: {
                        Integer n;
                        BasePubSubResult result;
                        JsonElement extractedMessage;
                        block18: {
                            int it2;
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                            if (message.getChannel$pubnub_core_impl() == null) {
                                                return null;
                                            }
                                            String channel = message.getChannel$pubnub_core_impl();
                                            String subscriptionMatch = message.getSubscriptionMatch$pubnub_core_impl();
                                            PublishMetaData publishMetaData = message.getPublishMetaData$pubnub_core_impl();
                                            if (Intrinsics.areEqual((Object)channel, (Object)subscriptionMatch)) {
                                                subscriptionMatch = null;
                                            }
                                            if (this.pubnub.getConfiguration().getDedupOnSubscribe()) {
                                                if (this.duplicationManager.isDuplicate(message)) {
                                                    return null;
                                                }
                                                this.duplicationManager.addEntry(message);
                                            }
                                            if (StringsKt.endsWith$default((String)message.getChannel$pubnub_core_impl(), (String)"-pnpres", (boolean)false, (int)2, null)) {
                                                JsonElement jsonElement;
                                                JsonElement jsonElement2;
                                                JsonElement jsonElement3;
                                                String string3;
                                                PresenceEnvelope presencePayload = this.pubnub.getMapper().convertValue(message.getPayload$pubnub_core_impl(), PresenceEnvelope.class);
                                                String strippedPresenceChannel = PubNubUtil.INSTANCE.replaceLast(channel, "-pnpres", "");
                                                String string4 = subscriptionMatch;
                                                if (string4 != null) {
                                                    String it2 = string4;
                                                    boolean bl = false;
                                                    string3 = PubNubUtil.INSTANCE.replaceLast(it2, "-pnpres", "");
                                                } else {
                                                    string3 = null;
                                                }
                                                String strippedPresenceSubscription = string3;
                                                JsonElement jsonElement4 = message.getPayload$pubnub_core_impl();
                                                JsonElement isHereNowRefresh = jsonElement4 != null && (jsonElement4 = jsonElement4.getAsJsonObject()) != null ? jsonElement4.get("here_now_refresh") : null;
                                                PublishMetaData publishMetaData2 = publishMetaData;
                                                return (PNEvent)new PNPresenceEventResult(presencePayload.getAction$pubnub_core_impl(), presencePayload.getUuid$pubnub_core_impl(), presencePayload.getTimestamp$pubnub_core_impl(), presencePayload.getOccupancy$pubnub_core_impl(), presencePayload.getData$pubnub_core_impl(), strippedPresenceChannel, strippedPresenceSubscription, publishMetaData2 != null ? publishMetaData2.getPublishTimetoken$pubnub_core_impl() : null, this.getDelta((jsonElement3 = message.getPayload$pubnub_core_impl()) != null && (jsonElement3 = jsonElement3.getAsJsonObject()) != null ? jsonElement3.get("join") : null), this.getDelta((jsonElement2 = message.getPayload$pubnub_core_impl()) != null && (jsonElement2 = jsonElement2.getAsJsonObject()) != null ? jsonElement2.get("leave") : null), this.getDelta((jsonElement = message.getPayload$pubnub_core_impl()) != null && (jsonElement = jsonElement.getAsJsonObject()) != null ? jsonElement.get("timeout") : null), Boolean.valueOf(isHereNowRefresh != null && isHereNowRefresh.getAsBoolean()), null, 4096, null);
                                            }
                                            Pair<JsonElement, PubNubError> pair = message.getPayload$pubnub_core_impl();
                                            if (pair == null || (pair = JsonElementKt.tryDecryptMessage((JsonElement)pair, this.pubnub.getConfiguration().getCryptoModule(), this.pubnub.getMapper())) == null) {
                                                pair = TuplesKt.to(null, null);
                                            }
                                            Pair<JsonElement, PubNubError> pair2 = pair;
                                            extractedMessage = (JsonElement)pair2.component1();
                                            error = (PubNubError)pair2.component2();
                                            if (extractedMessage == null) {
                                                this.log.debug("unable to parse payload on #processIncomingMessages");
                                            }
                                            PublishMetaData publishMetaData3 = publishMetaData;
                                            result = new BasePubSubResult(channel, subscriptionMatch, publishMetaData3 != null ? publishMetaData3.getPublishTimetoken$pubnub_core_impl() : null, message.getUserMetadata$pubnub_core_impl(), message.getIssuingClientId$pubnub_core_impl());
                                            n = message.getType$pubnub_core_impl();
                                            if (n != null) break block13;
                                            PubSubResult pubSubResult = (PubSubResult)result;
                                            JsonElement jsonElement = extractedMessage;
                                            Intrinsics.checkNotNull((Object)jsonElement);
                                            pNEvent = (PNEvent)new PNMessageResult(pubSubResult, jsonElement, error);
                                            break block14;
                                        }
                                        if (n != 0) break block15;
                                        PubSubResult pubSubResult = (PubSubResult)result;
                                        JsonElement jsonElement = extractedMessage;
                                        Intrinsics.checkNotNull((Object)jsonElement);
                                        pNEvent = (PNEvent)new PNMessageResult(pubSubResult, jsonElement, error);
                                        break block14;
                                    }
                                    it2 = 1;
                                    if (n != it2) break block16;
                                    PubSubResult pubSubResult = (PubSubResult)result;
                                    JsonElement jsonElement = extractedMessage;
                                    Intrinsics.checkNotNull((Object)jsonElement);
                                    pNEvent = (PNEvent)new PNSignalResult(pubSubResult, jsonElement);
                                    break block14;
                                }
                                it2 = 2;
                                if (n != it2) break block17;
                                pNEvent = (PNEvent)new PNObjectEventResult(result, this.pubnub.getMapper().convertValue(extractedMessage, PNObjectEventMessage.class));
                                break block14;
                            }
                            it2 = 3;
                            if (n != it2) break block18;
                            ObjectPayload objectPayload = this.pubnub.getMapper().convertValue(extractedMessage, ObjectPayload.class);
                            JsonObject data = objectPayload.getData().getAsJsonObject();
                            if (!data.has("uuid")) {
                                data.addProperty("uuid", result.getPublisher());
                            }
                            pNEvent = (PNEvent)new PNMessageActionResult(result, objectPayload.getEvent(), this.pubnub.getMapper().convertValue((JsonElement)data, PNMessageAction.class));
                            break block14;
                        }
                        int objectPayload = 4;
                        if (n != objectPayload) break block19;
                        FileUploadNotification fileUploadNotification = this.pubnub.getMapper().convertValue(extractedMessage, FileUploadNotification.class);
                        string2 = message.getChannel$pubnub_core_impl();
                        object2 = fileUploadNotification.getMessage();
                        pNDownloadableFile = new PNDownloadableFile(fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName(), this.buildFileUrl(message.getChannel$pubnub_core_impl(), fileUploadNotification.getFile().getId(), fileUploadNotification.getFile().getName()));
                        string = message.getIssuingClientId$pubnub_core_impl();
                        l = result.getTimetoken();
                        object = fileUploadNotification.getMessage();
                        if (object == null) break block20;
                        Object it = object;
                        boolean bl = false;
                        JsonElement jsonElement = this.pubnub.getMapper().toJsonTree(it);
                        object = jsonElement;
                        if (jsonElement != null) break block21;
                    }
                    object = (JsonElement)JsonNull.INSTANCE;
                }
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fileUploadNotification.m\u2026     ?: JsonNull.INSTANCE");
                pNEvent = (PNEvent)new PNFileEventResult(string2, l, string, object2, pNDownloadableFile, (JsonElement)object3, null, error, 64, null);
                break block14;
            }
            pNEvent = null;
        }
        return pNEvent;
    }

    private final String buildFileUrl(String channel, String fileId, String fileName) {
        ArrayList<String> queryParams;
        String basePath;
        block1: {
            String authKey;
            Object[] objectArray = new Object[]{this.pubnub.baseUrl$pubnub_core_impl(), this.pubnub.getConfiguration().getSubscribeKey(), channel, fileId, fileName};
            String string = String.format(this.formatFriendlyGetFileUrl, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(\n                \u2026  fileName,\n            )");
            basePath = string;
            queryParams = new ArrayList<String>();
            String string2 = authKey = BasePNConfiguration.Companion.isValid(this.pubnub.getConfiguration().getAuthKey()) ? this.pubnub.getConfiguration().getAuthKey() : null;
            if (PubNubUtil.INSTANCE.shouldSignRequest(this.pubnub.getConfiguration())) {
                int timestamp = PubNubCore.Companion.timestamp();
                String signature = this.generateSignature(this.pubnub.getConfiguration(), basePath, authKey, timestamp);
                queryParams.add("timestamp=" + timestamp);
                queryParams.add("signature=" + signature);
            }
            String string3 = authKey;
            if (string3 == null) break block1;
            String $this$buildFileUrl_u24lambda_u242 = string3;
            boolean bl = false;
            queryParams.add("auth=" + authKey);
        }
        return queryParams.isEmpty() ? basePath : basePath + '?' + CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private final String generateSignature(BasePNConfiguration configuration, String url, String authKey, int timestamp) {
        Map queryParams = new LinkedHashMap();
        if (authKey != null) {
            queryParams.put("auth", authKey);
        }
        return PubNubUtil.INSTANCE.generateSignature(url, queryParams, "get", null, timestamp, configuration.getSubscribeKey(), configuration.getPublishKey(), configuration.getSecretKey());
    }

    private final List<String> getDelta(JsonElement delta) {
        List list;
        block1: {
            list = new ArrayList();
            JsonElement jsonElement = delta;
            if (jsonElement == null) break block1;
            JsonElement it = jsonElement;
            boolean bl = false;
            JsonArray jsonArray = it.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"it.asJsonArray");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it2;
                JsonElement item = (JsonElement)element$iv;
                boolean bl2 = false;
                if (item == null) continue;
                boolean bl3 = false;
                String string = it2.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.asString");
                list.add(string);
            }
        }
        return list;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pubnub/internal/workers/SubscribeMessageProcessor$Companion;", "", "()V", "TYPE_FILES", "", "TYPE_MESSAGE", "TYPE_MESSAGE_ACTION", "TYPE_OBJECT", "TYPE_SIGNAL", "pubnub-core-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

