/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.objects_api.memberships;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.java.endpoints.objects_api.memberships.ManageMemberships;
import com.pubnub.api.java.endpoints.objects_api.memberships.ManageMembershipsBuilder;
import com.pubnub.api.java.endpoints.objects_api.utils.Include;
import com.pubnub.api.java.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNManageMembershipResult;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNManageMembershipResultConverter;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects.membership.MembershipInclude;
import com.pubnub.api.models.consumer.objects.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects.membership.PNChannelMembershipArrayResult;
import com.pubnub.internal.java.endpoints.DelegatingEndpoint;
import com.pubnub.internal.java.endpoints.objects_api.memberships.SetMembershipsImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ManageMembershipsImpl
extends DelegatingEndpoint<PNChannelMembershipArrayResult, PNManageMembershipResult>
implements ManageMemberships,
ManageMembershipsBuilder {
    private Collection<PNChannelMembership> set;
    private Collection<PNChannelMembership> remove;
    private String uuid;
    private String userId;
    private Integer limit;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private boolean includeType;
    private Include.PNChannelDetailsLevel includeChannel;
    private com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude include;

    public ManageMembershipsImpl(Collection<PNChannelMembership> channelsToSet, Collection<String> channelsToRemove, PubNub pubnubInstance) {
        super(pubnubInstance);
        this.set = channelsToSet;
        this.remove = this.getChannelMembershipsToRemove(channelsToRemove);
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNManageMembershipResult> mapResult(@NotNull ExtendedRemoteAction<PNChannelMembershipArrayResult> action) {
        return new MappingRemoteAction(action, PNManageMembershipResultConverter::from);
    }

    @Override
    @NotNull
    protected Endpoint<PNChannelMembershipArrayResult> createRemoteAction() {
        ArrayList<PNChannelMembership.Partial> toSet = new ArrayList<PNChannelMembership.Partial>(this.set.size());
        for (PNChannelMembership channel : this.set) {
            toSet.add(new PNChannelMembership.Partial(channel.getChannel().getId(), channel.getCustom(), channel.getStatus(), channel.getType()));
        }
        List channelIdsToRemove = this.remove.stream().map(membership -> membership.getChannel().getId()).collect(Collectors.toList());
        return this.pubnub.manageMemberships(toSet, channelIdsToRemove, this.getUserId(), this.limit, this.page, this.filter, SetMembershipsImpl.toInternal(this.sort), (MembershipInclude)SetMembershipsImpl.getMembershipInclude(this.include, this.includeChannel, this.includeTotalCount, this.includeCustom, this.includeType));
    }

    private String getUserId() {
        return this.userId != null ? this.userId : this.uuid;
    }

    private Collection<PNChannelMembership> getChannelMembershipsToRemove(Collection<String> channelsToRemove) {
        ArrayList<PNChannelMembership> channelMembershipsToRemove = new ArrayList<PNChannelMembership>();
        for (String channelIdToRemove : channelsToRemove) {
            channelMembershipsToRemove.add(PNChannelMembership.channel((String)channelIdToRemove));
        }
        return channelMembershipsToRemove;
    }

    public ManageMembershipsImpl set(Collection<PNChannelMembership> set) {
        this.set = set;
        return this;
    }

    public ManageMembershipsImpl remove(Collection<PNChannelMembership> remove) {
        this.remove = remove;
        return this;
    }

    public ManageMembershipsImpl uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public ManageMembershipsImpl userId(String userId) {
        this.userId = userId;
        return this;
    }

    public ManageMembershipsImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ManageMembershipsImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public ManageMembershipsImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public ManageMembershipsImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public ManageMembershipsImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public ManageMembershipsImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public ManageMembershipsImpl includeType(boolean includeType) {
        this.includeType = includeType;
        return this;
    }

    public ManageMembershipsImpl includeChannel(Include.PNChannelDetailsLevel includeChannel) {
        this.includeChannel = includeChannel;
        return this;
    }

    public ManageMembershipsImpl include(com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude include) {
        this.include = include;
        return this;
    }

    public static class Builder
    implements ManageMemberships.Builder {
        private final PubNub pubnubInstance;

        public Builder(PubNub pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }

        public ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageMemberships, PNChannelMembership> set(final Collection<PNChannelMembership> channelsToSet) {
            return new ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageMemberships, PNChannelMembership>(){

                public ManageMemberships remove(Collection<PNChannelMembership> channelsToRemove) {
                    List<String> channelIdsToRemove = channelsToRemove.stream().map(membership -> membership.getChannel().getId()).collect(Collectors.toList());
                    return new ManageMembershipsImpl(channelsToSet, channelIdsToRemove, pubnubInstance);
                }
            };
        }

        public ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageMemberships, PNChannelMembership> remove(Collection<PNChannelMembership> channelsToRemove) {
            final List channelIdsToRemove = channelsToRemove.stream().map(membership -> membership.getChannel().getId()).collect(Collectors.toList());
            return new ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageMemberships, PNChannelMembership>(){

                public ManageMemberships set(Collection<PNChannelMembership> channelsToSet) {
                    return new ManageMembershipsImpl(channelsToSet, channelIdsToRemove, pubnubInstance);
                }
            };
        }
    }
}

