/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.pubsub.Publish;
import com.pubnub.api.java.v2.endpoints.pubsub.PublishBuilder;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class PublishImpl
extends PassthroughEndpoint<PNPublishResult>
implements Publish,
PublishBuilder {
    private Object message;
    private String channel;
    private Boolean shouldStore;
    private boolean usePOST;
    private Object meta;
    private boolean replicate = true;
    private Integer ttl;
    private String customMessageType;

    public PublishImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNPublishResult> createRemoteAction() {
        return this.pubnub.publish(this.channel, this.message, this.meta, this.shouldStore, this.usePOST, this.replicate, this.ttl, this.customMessageType);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.message == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_MISSING);
        }
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public PublishImpl message(Object message) {
        this.message = message;
        return this;
    }

    public PublishImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    public PublishImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public PublishImpl usePOST(boolean usePOST) {
        this.usePOST = usePOST;
        return this;
    }

    public PublishImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public PublishImpl replicate(boolean replicate) {
        this.replicate = replicate;
        return this;
    }

    public PublishImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public PublishImpl customMessageType(String customMessageType) {
        this.customMessageType = customMessageType;
        return this;
    }
}

