/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.access;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.java.endpoints.access.Grant;
import com.pubnub.api.java.models.consumer.access_manager.PNAccessManagerGrantResult;
import com.pubnub.internal.java.endpoints.DelegatingEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GrantImpl
extends DelegatingEndpoint<com.pubnub.api.models.consumer.access_manager.PNAccessManagerGrantResult, PNAccessManagerGrantResult>
implements Grant {
    private boolean read;
    private boolean write;
    private boolean manage;
    private boolean delete;
    private boolean get;
    private boolean update;
    private boolean join;
    private int ttl = -1;
    private List<String> authKeys = new ArrayList<String>();
    private List<String> channels = new ArrayList<String>();
    private List<String> channelGroups = new ArrayList<String>();
    private List<String> uuids = Collections.emptyList();

    public GrantImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<com.pubnub.api.models.consumer.access_manager.PNAccessManagerGrantResult> createRemoteAction() {
        return this.pubnub.grant(this.read, this.write, this.manage, this.delete, this.get, this.update, this.join, this.ttl, this.authKeys, this.channels, this.channelGroups, this.uuids);
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNAccessManagerGrantResult> mapResult(@NotNull ExtendedRemoteAction<com.pubnub.api.models.consumer.access_manager.PNAccessManagerGrantResult> action) {
        return new MappingRemoteAction(action, PNAccessManagerGrantResult::from);
    }

    public GrantImpl read(boolean read) {
        this.read = read;
        return this;
    }

    public GrantImpl write(boolean write) {
        this.write = write;
        return this;
    }

    public GrantImpl manage(boolean manage) {
        this.manage = manage;
        return this;
    }

    public GrantImpl delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public GrantImpl get(boolean get) {
        this.get = get;
        return this;
    }

    public GrantImpl update(boolean update) {
        this.update = update;
        return this;
    }

    public GrantImpl join(boolean join) {
        this.join = join;
        return this;
    }

    public GrantImpl ttl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public GrantImpl authKeys(List<String> authKeys) {
        this.authKeys = authKeys;
        return this;
    }

    public GrantImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public GrantImpl channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public GrantImpl uuids(List<String> uuids) {
        this.uuids = uuids;
        return this;
    }
}

