/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.message_actions;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.endpoints.message_actions.RemoveMessageAction;
import com.pubnub.api.models.consumer.message_actions.PNRemoveMessageActionResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;

public class RemoveMessageActionImpl
extends PassthroughEndpoint<PNRemoveMessageActionResult>
implements RemoveMessageAction {
    private String channel;
    private Long messageTimetoken;
    private Long actionTimetoken;

    public RemoveMessageActionImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    protected Endpoint<PNRemoveMessageActionResult> createRemoteAction() {
        return this.pubnub.removeMessageAction(this.channel, this.messageTimetoken.longValue(), this.actionTimetoken.longValue());
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.messageTimetoken == null) {
            throw new PubNubException(PubNubError.MESSAGE_TIMETOKEN_MISSING);
        }
        if (this.actionTimetoken == null) {
            throw new PubNubException(PubNubError.MESSAGE_ACTION_TIMETOKEN_MISSING);
        }
    }

    public RemoveMessageActionImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    public RemoveMessageActionImpl messageTimetoken(Long messageTimetoken) {
        this.messageTimetoken = messageTimetoken;
        return this;
    }

    public RemoveMessageActionImpl actionTimetoken(Long actionTimetoken) {
        this.actionTimetoken = actionTimetoken;
        return this;
    }
}

