/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.objects_api.members;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.java.endpoints.objects_api.members.SetChannelMembers;
import com.pubnub.api.java.endpoints.objects_api.members.SetChannelMembersBuilder;
import com.pubnub.api.java.endpoints.objects_api.utils.Include;
import com.pubnub.api.java.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.java.models.consumer.objects_api.member.MemberInclude;
import com.pubnub.api.java.models.consumer.objects_api.member.PNSetChannelMembersResult;
import com.pubnub.api.java.models.consumer.objects_api.member.PNSetChannelMembersResultConverter;
import com.pubnub.api.java.models.consumer.objects_api.member.PNUUID;
import com.pubnub.api.java.models.consumer.objects_api.member.PNUser;
import com.pubnub.api.models.consumer.objects.PNMemberKey;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects.PNSortKey;
import com.pubnub.api.models.consumer.objects.SortField;
import com.pubnub.api.models.consumer.objects.member.MemberInput;
import com.pubnub.api.models.consumer.objects.member.PNMember;
import com.pubnub.api.models.consumer.objects.member.PNMemberArrayResult;
import com.pubnub.api.models.consumer.objects.member.PNUUIDDetailsLevel;
import com.pubnub.internal.java.endpoints.DelegatingEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNSetChannelMembersResult>
implements SetChannelMembers,
SetChannelMembersBuilder {
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private boolean includeType;
    private Include.PNUUIDDetailsLevel includeUUID;
    private final String channel;
    private Collection<PNUUID> uuids;
    private Collection<PNUser> users;
    private MemberInclude include;

    @Deprecated
    private SetChannelMembersImpl(PubNub pubnubInstance, String channel, Collection<PNUUID> uuids) {
        super(pubnubInstance);
        this.channel = channel;
        this.uuids = uuids;
    }

    public SetChannelMembersImpl(String channel, Collection<PNUser> users, PubNub pubnubInstance) {
        super(pubnubInstance);
        this.channel = channel;
        this.users = users;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNSetChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        MappingRemoteAction pnMemberArrayResultPNSetChannelMembersResultMappingRemoteAction = new MappingRemoteAction(action, PNSetChannelMembersResultConverter::from);
        return pnMemberArrayResultPNSetChannelMembersResultMappingRemoteAction;
    }

    @Override
    @NotNull
    protected Endpoint<PNMemberArrayResult> createRemoteAction() {
        return this.pubnub.setChannelMembers(this.channel, this.createMemberInputs(), this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), (com.pubnub.api.models.consumer.objects.member.MemberInclude)SetChannelMembersImpl.getMemberInclude(this.include, this.includeUUID, this.includeTotalCount, this.includeCustom, this.includeType));
    }

    static Collection<? extends PNSortKey<PNMemberKey>> toInternal(Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort) {
        ArrayList<Object> list = new ArrayList<Object>(sort.size());
        for (com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey pnSortKey : sort) {
            PNMemberKey key = null;
            switch (pnSortKey.getKey()) {
                case ID: {
                    key = PNMemberKey.UUID_ID;
                    break;
                }
                case NAME: {
                    key = PNMemberKey.UUID_NAME;
                    break;
                }
                case UPDATED: {
                    key = PNMemberKey.UUID_UPDATED;
                    break;
                }
                case STATUS: {
                    key = PNMemberKey.STATUS;
                    break;
                }
                case TYPE: {
                    key = PNMemberKey.TYPE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never happen");
                }
            }
            if (pnSortKey.getDir().equals((Object)PNSortKey.Dir.ASC)) {
                list.add(new PNSortKey.PNAsc((SortField)key));
                continue;
            }
            list.add(new PNSortKey.PNDesc((SortField)key));
        }
        return list;
    }

    @Nullable
    static PNUUIDDetailsLevel toInternal(Include.PNUUIDDetailsLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        switch (detailLevel) {
            case UUID: {
                return PNUUIDDetailsLevel.UUID;
            }
            case UUID_WITH_CUSTOM: {
                return PNUUIDDetailsLevel.UUID_WITH_CUSTOM;
            }
        }
        throw new IllegalStateException("Unknown detail level: " + detailLevel);
    }

    private List<MemberInput> createMemberInputs() {
        ArrayList<MemberInput> memberInputs;
        block3: {
            block2: {
                memberInputs = new ArrayList<MemberInput>();
                if (this.users == null) break block2;
                for (PNUser user : this.users) {
                    memberInputs.add((MemberInput)new PNMember.Partial(user.getUserId(), user.getCustom(), user.getStatus(), user.getType()));
                }
                break block3;
            }
            if (this.uuids == null) break block3;
            for (PNUUID uuid : this.uuids) {
                memberInputs.add((MemberInput)new PNMember.Partial(uuid.getUuid().getId(), uuid instanceof PNUUID.UUIDWithCustom ? ((PNUUID.UUIDWithCustom)uuid).getCustom() : null, uuid.getStatus(), null));
            }
        }
        return memberInputs;
    }

    static MemberInclude getMemberInclude(MemberInclude include, Include.PNUUIDDetailsLevel includeUser, boolean includeTotalCount, boolean includeCustom, boolean includeType) {
        if (include != null) {
            return include;
        }
        MemberInclude.Builder builderWithCommonParams = MemberInclude.builder().includeTotalCount(includeTotalCount).includeCustom(includeCustom).includeUserType(includeType);
        if (includeUser == Include.PNUUIDDetailsLevel.UUID) {
            return builderWithCommonParams.includeStatus(true).includeUser(true).build();
        }
        if (includeUser == Include.PNUUIDDetailsLevel.UUID_WITH_CUSTOM) {
            return builderWithCommonParams.includeStatus(true).includeUser(true).includeUserCustom(true).build();
        }
        return builderWithCommonParams.build();
    }

    public SetChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public SetChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public SetChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public SetChannelMembersImpl sort(Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public SetChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public SetChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public SetChannelMembersImpl includeType(boolean includeType) {
        this.includeType = includeType;
        return this;
    }

    public SetChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public SetChannelMembersImpl uuids(Collection<PNUUID> uuids) {
        this.uuids = uuids;
        return this;
    }

    public SetChannelMembersImpl users(Collection<PNUser> users) {
        this.users = users;
        return this;
    }

    public SetChannelMembersImpl include(MemberInclude include) {
        this.include = include;
        return this;
    }

    public static class Builder
    implements SetChannelMembers.Builder {
        private final PubNub pubnubInstance;

        public Builder(PubNub pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }

        public ObjectsBuilderSteps.UUIDsStep<SetChannelMembers> channel(final String channel) {
            return new ObjectsBuilderSteps.UUIDsStep<SetChannelMembers>(){

                public SetChannelMembers uuids(@NotNull Collection<PNUUID> uuids) {
                    return new SetChannelMembersImpl(pubnubInstance, channel, uuids);
                }
            };
        }
    }
}

