/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.presence.SetState;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.presence.HeartbeatEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class SetStateImpl
extends DelegatingEndpoint<Object, PNSetStateResult>
implements SetState {
    @NotNull
    private List<String> channels = new ArrayList<String>();
    @NotNull
    private List<String> channelGroups = new ArrayList<String>();
    private Object state;
    @NotNull
    private String uuid = this.pubnub.getConfiguration().getUuid();
    private boolean withHeartbeat;

    public SetStateImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.state == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_STATE_MISSING);
        }
        String stringifiedState = this.pubnub.getMapper().toJson(this.state);
        if (!this.isJsonObject(stringifiedState)) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_STATE_MUST_BE_JSON_OBJECT);
        }
        if (this.withHeartbeat && this.uuid != null && !this.uuid.equals(this.pubnub.getConfiguration().getUserId().getValue())) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_USERID_CAN_NOT_BE_DIFFERENT_FROM_IN_CONFIGURATION_WHEN_WITHHEARTBEAT_TRUE);
        }
    }

    private boolean isJsonObject(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNSetStateResult> mapResult(@NotNull ExtendedRemoteAction<Object> action) {
        if (this.withHeartbeat) {
            return new MappingRemoteAction(action, result -> new PNSetStateResult(this.pubnub.getMapper().toJsonTree(this.state)));
        }
        return new MappingRemoteAction(action, result -> (PNSetStateResult)result);
    }

    @Override
    @NotNull
    protected EndpointInterface<Object> createAction() {
        if (!this.withHeartbeat) {
            return (EndpointInterface)this.pubnub.setPresenceState(this.channels, this.channelGroups, this.state, this.uuid);
        }
        return (EndpointInterface)new HeartbeatEndpoint(this.pubnub, this.channels, this.channelGroups, this.composeStateParamValue());
    }

    private Object composeStateParamValue() {
        HashMap<String, Object> stateParamValue = new HashMap<String, Object>();
        for (String channel : this.channels) {
            stateParamValue.put(channel, this.state);
        }
        return stateParamValue;
    }

    public SetStateImpl channels(@NotNull List<String> channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        this.channels = channels;
        return this;
    }

    public SetStateImpl channelGroups(@NotNull List<String> channelGroups) {
        if (channelGroups == null) {
            throw new NullPointerException("channelGroups is marked non-null but is null");
        }
        this.channelGroups = channelGroups;
        return this;
    }

    public SetStateImpl state(Object state) {
        this.state = state;
        return this;
    }

    public SetStateImpl uuid(@NotNull String uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
        return this;
    }

    public SetStateImpl withHeartbeat(boolean withHeartbeat) {
        this.withHeartbeat = withHeartbeat;
        return this;
    }
}

