/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.push.AddChannelsToPush;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushAddChannelResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddChannelsToPushImpl
extends IdentityMappingEndpoint<PNPushAddChannelResult>
implements AddChannelsToPush {
    private PNPushType pushType;
    private List<String> channels;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public AddChannelsToPushImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNPushAddChannelResult> createAction() {
        return this.pubnub.addPushNotificationsOnChannels(this.pushType, this.channels, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
        if (this.channels == null || this.channels.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public AddChannelsToPushImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public AddChannelsToPushImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public AddChannelsToPushImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public AddChannelsToPushImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AddChannelsToPushImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

