/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.enums.PNReconnectionPolicy;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.logging.HttpLoggingInterceptor;

public class PNConfiguration {
    private static final int DEFAULT_DEDUPE_SIZE = 100;
    private static final int PRESENCE_TIMEOUT = 300;
    private static final int NON_SUBSCRIBE_REQUEST_TIMEOUT = 10;
    private static final int SUBSCRIBE_TIMEOUT = 310;
    private static final int CONNECT_TIMEOUT = 5;
    private SSLSocketFactory sslSocketFactory;
    private X509ExtendedTrustManager x509ExtendedTrustManager;
    private ConnectionSpec connectionSpec;
    private HostnameVerifier hostnameVerifier;
    private boolean includeInstanceIdentifier;
    private boolean includeRequestIdentifier;
    private String origin;
    private int subscribeTimeout;
    private int presenceTimeout;
    private int heartbeatInterval;
    private boolean secure;
    private String subscribeKey;
    private String publishKey;
    private String secretKey;
    private String cipherKey;
    private String authKey;
    private String uuid;
    @Deprecated
    private boolean cacheBusting;
    private PNLogVerbosity logVerbosity;
    private int connectTimeout;
    private int nonSubscribeRequestTimeout;
    private boolean supressLeaveEvents;
    private PNHeartbeatNotificationOptions heartbeatNotificationOptions;
    private String filterExpression;
    private PNReconnectionPolicy reconnectionPolicy;
    private int maximumReconnectionRetries;
    private Proxy proxy;
    private ProxySelector proxySelector;
    private Authenticator proxyAuthenticator;
    private CertificatePinner certificatePinner;
    private Integer maximumConnections;
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private Integer requestMessageCountThreshold;
    private boolean googleAppEngineNetworking;
    private boolean startSubscriberThread;
    private boolean dedupOnSubscribe;
    private Integer maximumMessagesCacheSize;

    public PNConfiguration() {
        this.setPresenceTimeout(300);
        this.uuid = "pn-" + UUID.randomUUID().toString();
        this.nonSubscribeRequestTimeout = 10;
        this.subscribeTimeout = 310;
        this.connectTimeout = 5;
        this.logVerbosity = PNLogVerbosity.NONE;
        this.heartbeatNotificationOptions = PNHeartbeatNotificationOptions.FAILURES;
        this.reconnectionPolicy = PNReconnectionPolicy.NONE;
        this.secure = true;
        this.includeInstanceIdentifier = false;
        this.includeRequestIdentifier = true;
        this.startSubscriberThread = true;
        this.maximumReconnectionRetries = -1;
        this.dedupOnSubscribe = false;
        this.supressLeaveEvents = false;
        this.maximumMessagesCacheSize = 100;
    }

    public PNConfiguration setPresenceTimeoutWithCustomInterval(int timeout, int interval) {
        this.presenceTimeout = timeout;
        this.heartbeatInterval = interval;
        return this;
    }

    public PNConfiguration setPresenceTimeout(int timeout) {
        return this.setPresenceTimeoutWithCustomInterval(timeout, timeout / 2 - 1);
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getSubscribeTimeout() {
        return this.subscribeTimeout;
    }

    public int getPresenceTimeout() {
        return this.presenceTimeout;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getSubscribeKey() {
        return this.subscribeKey;
    }

    public String getPublishKey() {
        return this.publishKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public boolean isCacheBusting() {
        return this.cacheBusting;
    }

    public PNLogVerbosity getLogVerbosity() {
        return this.logVerbosity;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getNonSubscribeRequestTimeout() {
        return this.nonSubscribeRequestTimeout;
    }

    public boolean isSupressLeaveEvents() {
        return this.supressLeaveEvents;
    }

    public PNHeartbeatNotificationOptions getHeartbeatNotificationOptions() {
        return this.heartbeatNotificationOptions;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public PNReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public int getMaximumReconnectionRetries() {
        return this.maximumReconnectionRetries;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public Integer getMaximumConnections() {
        return this.maximumConnections;
    }

    public HttpLoggingInterceptor getHttpLoggingInterceptor() {
        return this.httpLoggingInterceptor;
    }

    public Integer getRequestMessageCountThreshold() {
        return this.requestMessageCountThreshold;
    }

    public boolean isGoogleAppEngineNetworking() {
        return this.googleAppEngineNetworking;
    }

    public boolean isStartSubscriberThread() {
        return this.startSubscriberThread;
    }

    public boolean isDedupOnSubscribe() {
        return this.dedupOnSubscribe;
    }

    public Integer getMaximumMessagesCacheSize() {
        return this.maximumMessagesCacheSize;
    }

    public PNConfiguration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public PNConfiguration setX509ExtendedTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager) {
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
        return this;
    }

    public PNConfiguration setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        return this;
    }

    public PNConfiguration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public PNConfiguration setIncludeInstanceIdentifier(boolean includeInstanceIdentifier) {
        this.includeInstanceIdentifier = includeInstanceIdentifier;
        return this;
    }

    public PNConfiguration setIncludeRequestIdentifier(boolean includeRequestIdentifier) {
        this.includeRequestIdentifier = includeRequestIdentifier;
        return this;
    }

    public PNConfiguration setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public PNConfiguration setSubscribeTimeout(int subscribeTimeout) {
        this.subscribeTimeout = subscribeTimeout;
        return this;
    }

    public PNConfiguration setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public PNConfiguration setSubscribeKey(String subscribeKey) {
        this.subscribeKey = subscribeKey;
        return this;
    }

    public PNConfiguration setPublishKey(String publishKey) {
        this.publishKey = publishKey;
        return this;
    }

    public PNConfiguration setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public PNConfiguration setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public PNConfiguration setAuthKey(String authKey) {
        this.authKey = authKey;
        return this;
    }

    public PNConfiguration setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Deprecated
    public PNConfiguration setCacheBusting(boolean cacheBusting) {
        this.cacheBusting = cacheBusting;
        return this;
    }

    public PNConfiguration setLogVerbosity(PNLogVerbosity logVerbosity) {
        this.logVerbosity = logVerbosity;
        return this;
    }

    public PNConfiguration setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public PNConfiguration setNonSubscribeRequestTimeout(int nonSubscribeRequestTimeout) {
        this.nonSubscribeRequestTimeout = nonSubscribeRequestTimeout;
        return this;
    }

    public PNConfiguration setSupressLeaveEvents(boolean supressLeaveEvents) {
        this.supressLeaveEvents = supressLeaveEvents;
        return this;
    }

    public PNConfiguration setHeartbeatNotificationOptions(PNHeartbeatNotificationOptions heartbeatNotificationOptions) {
        this.heartbeatNotificationOptions = heartbeatNotificationOptions;
        return this;
    }

    public PNConfiguration setRequestMessageCountThreshold(Integer requestMessageCountThreshold) {
        this.requestMessageCountThreshold = requestMessageCountThreshold;
        return this;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509ExtendedTrustManager getX509ExtendedTrustManager() {
        return this.x509ExtendedTrustManager;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean isIncludeInstanceIdentifier() {
        return this.includeInstanceIdentifier;
    }

    public boolean isIncludeRequestIdentifier() {
        return this.includeRequestIdentifier;
    }

    public PNConfiguration setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public PNConfiguration setReconnectionPolicy(PNReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
        return this;
    }

    public PNConfiguration setMaximumReconnectionRetries(int maximumReconnectionRetries) {
        this.maximumReconnectionRetries = maximumReconnectionRetries;
        return this;
    }

    public PNConfiguration setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public PNConfiguration setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public PNConfiguration setProxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        return this;
    }

    public PNConfiguration setCertificatePinner(CertificatePinner certificatePinner) {
        this.certificatePinner = certificatePinner;
        return this;
    }

    public PNConfiguration setMaximumConnections(Integer maximumConnections) {
        this.maximumConnections = maximumConnections;
        return this;
    }

    public PNConfiguration setHttpLoggingInterceptor(HttpLoggingInterceptor httpLoggingInterceptor) {
        this.httpLoggingInterceptor = httpLoggingInterceptor;
        return this;
    }

    public PNConfiguration setGoogleAppEngineNetworking(boolean googleAppEngineNetworking) {
        this.googleAppEngineNetworking = googleAppEngineNetworking;
        return this;
    }

    public PNConfiguration setStartSubscriberThread(boolean startSubscriberThread) {
        this.startSubscriberThread = startSubscriberThread;
        return this;
    }

    public PNConfiguration setDedupOnSubscribe(boolean dedupOnSubscribe) {
        this.dedupOnSubscribe = dedupOnSubscribe;
        return this;
    }

    public PNConfiguration setMaximumMessagesCacheSize(Integer maximumMessagesCacheSize) {
        this.maximumMessagesCacheSize = maximumMessagesCacheSize;
        return this;
    }
}

