/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PresenceBuilder;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.builder.SubscribeBuilder;
import com.pubnub.api.builder.UnsubscribeBuilder;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.endpoints.DeleteMessages;
import com.pubnub.api.endpoints.FetchMessages;
import com.pubnub.api.endpoints.History;
import com.pubnub.api.endpoints.Time;
import com.pubnub.api.endpoints.access.Audit;
import com.pubnub.api.endpoints.access.Grant;
import com.pubnub.api.endpoints.channel_groups.AddChannelChannelGroup;
import com.pubnub.api.endpoints.channel_groups.AllChannelsChannelGroup;
import com.pubnub.api.endpoints.channel_groups.DeleteChannelGroup;
import com.pubnub.api.endpoints.channel_groups.ListAllChannelGroup;
import com.pubnub.api.endpoints.channel_groups.RemoveChannelChannelGroup;
import com.pubnub.api.endpoints.presence.GetState;
import com.pubnub.api.endpoints.presence.HereNow;
import com.pubnub.api.endpoints.presence.SetState;
import com.pubnub.api.endpoints.presence.WhereNow;
import com.pubnub.api.endpoints.pubsub.Publish;
import com.pubnub.api.endpoints.push.AddChannelsToPush;
import com.pubnub.api.endpoints.push.ListPushProvisions;
import com.pubnub.api.endpoints.push.RemoveAllPushChannelsForDevice;
import com.pubnub.api.endpoints.push.RemoveChannelsFromPush;
import com.pubnub.api.managers.BasePathManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.PublishSequenceManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.SubscriptionManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.vendor.Crypto;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PubNub {
    private PNConfiguration configuration;
    private MapperManager mapper;
    private String instanceId;
    private SubscriptionManager subscriptionManager;
    private BasePathManager basePathManager;
    private PublishSequenceManager publishSequenceManager;
    private TelemetryManager telemetryManager;
    private RetrofitManager retrofitManager;
    private static final int TIMESTAMP_DIVIDER = 1000;
    private static final int MAX_SEQUENCE = 65535;
    private static final String SDK_VERSION = "4.18.0";

    public PubNub(PNConfiguration initialConfig) {
        this.configuration = initialConfig;
        this.mapper = new MapperManager();
        this.telemetryManager = new TelemetryManager();
        this.basePathManager = new BasePathManager(initialConfig);
        this.retrofitManager = new RetrofitManager(this);
        this.subscriptionManager = new SubscriptionManager(this, this.retrofitManager, this.telemetryManager);
        this.publishSequenceManager = new PublishSequenceManager(65535);
        this.instanceId = UUID.randomUUID().toString();
    }

    public String getBaseUrl() {
        return this.basePathManager.getBasePath();
    }

    public void addListener(SubscribeCallback listener) {
        this.subscriptionManager.addListener(listener);
    }

    public void removeListener(SubscribeCallback listener) {
        this.subscriptionManager.removeListener(listener);
    }

    public SubscribeBuilder subscribe() {
        return new SubscribeBuilder(this.subscriptionManager);
    }

    public UnsubscribeBuilder unsubscribe() {
        return new UnsubscribeBuilder(this.subscriptionManager);
    }

    public PresenceBuilder presence() {
        return new PresenceBuilder(this.subscriptionManager);
    }

    public AddChannelsToPush addPushNotificationsOnChannels() {
        return new AddChannelsToPush(this, this.telemetryManager, this.retrofitManager);
    }

    public RemoveChannelsFromPush removePushNotificationsFromChannels() {
        return new RemoveChannelsFromPush(this, this.telemetryManager, this.retrofitManager);
    }

    public RemoveAllPushChannelsForDevice removeAllPushNotificationsFromDeviceWithPushToken() {
        return new RemoveAllPushChannelsForDevice(this, this.telemetryManager, this.retrofitManager);
    }

    public ListPushProvisions auditPushChannelProvisions() {
        return new ListPushProvisions(this, this.telemetryManager, this.retrofitManager);
    }

    public WhereNow whereNow() {
        return new WhereNow(this, this.telemetryManager, this.retrofitManager);
    }

    public HereNow hereNow() {
        return new HereNow(this, this.telemetryManager, this.retrofitManager);
    }

    public Time time() {
        return new Time(this, this.telemetryManager, this.retrofitManager);
    }

    public History history() {
        return new History(this, this.telemetryManager, this.retrofitManager);
    }

    public FetchMessages fetchMessages() {
        return new FetchMessages(this, this.telemetryManager, this.retrofitManager);
    }

    public DeleteMessages deleteMessages() {
        return new DeleteMessages(this, this.telemetryManager, this.retrofitManager);
    }

    public Audit audit() {
        return new Audit(this, this.telemetryManager, this.retrofitManager);
    }

    public Grant grant() {
        return new Grant(this, this.telemetryManager, this.retrofitManager);
    }

    public GetState getPresenceState() {
        return new GetState(this, this.telemetryManager, this.retrofitManager);
    }

    public SetState setPresenceState() {
        return new SetState(this, this.subscriptionManager, this.telemetryManager, this.retrofitManager);
    }

    public Publish publish() {
        return new Publish(this, this.publishSequenceManager, this.telemetryManager, this.retrofitManager);
    }

    public ListAllChannelGroup listAllChannelGroups() {
        return new ListAllChannelGroup(this, this.telemetryManager, this.retrofitManager);
    }

    public AllChannelsChannelGroup listChannelsForChannelGroup() {
        return new AllChannelsChannelGroup(this, this.telemetryManager, this.retrofitManager);
    }

    public AddChannelChannelGroup addChannelsToChannelGroup() {
        return new AddChannelChannelGroup(this, this.telemetryManager, this.retrofitManager);
    }

    public RemoveChannelChannelGroup removeChannelsFromChannelGroup() {
        return new RemoveChannelChannelGroup(this, this.telemetryManager, this.retrofitManager);
    }

    public DeleteChannelGroup deleteChannelGroup() {
        return new DeleteChannelGroup(this, this.telemetryManager, this.retrofitManager);
    }

    public String decrypt(String inputString) throws PubNubException {
        if (inputString == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).build();
        }
        return this.decrypt(inputString, this.getConfiguration().getCipherKey());
    }

    public String decrypt(String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).build();
        }
        return new Crypto(cipherKey).decrypt(inputString);
    }

    public String encrypt(String inputString) throws PubNubException {
        if (inputString == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).build();
        }
        return this.encrypt(inputString, this.getConfiguration().getCipherKey());
    }

    public String encrypt(String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).build();
        }
        return new Crypto(cipherKey).encrypt(inputString);
    }

    public int getTimestamp() {
        return (int)(new Date().getTime() / 1000L);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRequestId() {
        return UUID.randomUUID().toString();
    }

    public String getVersion() {
        return SDK_VERSION;
    }

    @Deprecated
    public void stop() {
        this.subscriptionManager.stop();
    }

    public void destroy() {
        try {
            this.subscriptionManager.destroy(false);
            this.retrofitManager.destroy(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void forceDestroy() {
        try {
            this.subscriptionManager.destroy(true);
            this.retrofitManager.destroy(true);
            this.telemetryManager.stopCleanUpTimer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reconnect() {
        this.subscriptionManager.reconnect();
    }

    public void disconnect() {
        this.subscriptionManager.disconnect();
    }

    public Publish fire() {
        return this.publish().shouldStore(false).replicate(false);
    }

    public List<String> getSubscribedChannels() {
        return this.subscriptionManager.getSubscribedChannels();
    }

    public List<String> getSubscribedChannelGroups() {
        return this.subscriptionManager.getSubscribedChannelGroups();
    }

    public void unsubscribeAll() {
        this.subscriptionManager.unsubscribeAll();
    }

    public PNConfiguration getConfiguration() {
        return this.configuration;
    }

    public MapperManager getMapper() {
        return this.mapper;
    }
}

