/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.history.PNDeleteMessagesResult;
import com.pubnub.api.models.server.DeleteMessagesEnvelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class DeleteMessages
extends Endpoint<DeleteMessagesEnvelope, PNDeleteMessagesResult> {
    private static final int SERVER_RESPONSE_SUCCESS = 200;
    private List<String> channels = new ArrayList<String>();
    private Long start;
    private Long end;

    public DeleteMessages(PubNub pubnubInstance, TelemetryManager telemetryManager, RetrofitManager retrofitInstance) {
        super(pubnubInstance, telemetryManager, retrofitInstance);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<DeleteMessagesEnvelope> doWork(Map<String, String> params) throws PubNubException {
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        return this.getRetrofit().getHistoryService().deleteMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtil.joinString(this.channels, ","), params);
    }

    @Override
    protected PNDeleteMessagesResult createResponse(Response<DeleteMessagesEnvelope> input) throws PubNubException {
        if (input.body() == null || ((DeleteMessagesEnvelope)input.body()).getStatus() == null || ((DeleteMessagesEnvelope)input.body()).getStatus() != 200) {
            String errorMsg = null;
            errorMsg = input.body() != null && ((DeleteMessagesEnvelope)input.body()).getErrorMessage() != null ? ((DeleteMessagesEnvelope)input.body()).getErrorMessage() : "n/a";
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).errormsg(errorMsg).build();
        }
        return PNDeleteMessagesResult.builder().build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNDeleteMessagesOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public DeleteMessages channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public DeleteMessages start(Long start) {
        this.start = start;
        return this;
    }

    public DeleteMessages end(Long end) {
        this.end = end;
        return this;
    }
}

