/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.history.PNHistoryItemResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class History
extends Endpoint<JsonElement, PNHistoryResult> {
    private static final int MAX_COUNT = 100;
    private String channel;
    private Long start;
    private Long end;
    private Boolean reverse;
    private Integer count;
    private Boolean includeTimetoken;

    public History(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit) {
        super(pubnub, telemetryManager, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
    }

    @Override
    protected Call<JsonElement> doWork(Map<String, String> params) {
        if (this.reverse != null) {
            params.put("reverse", String.valueOf(this.reverse));
        }
        if (this.includeTimetoken != null) {
            params.put("include_token", String.valueOf(this.includeTimetoken));
        }
        if (this.count != null && this.count > 0 && this.count <= 100) {
            params.put("count", String.valueOf(this.count));
        } else {
            params.put("count", "100");
        }
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        return this.getRetrofit().getHistoryService().fetchHistory(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, params);
    }

    @Override
    protected PNHistoryResult createResponse(Response<JsonElement> input) throws PubNubException {
        PNHistoryResult.PNHistoryResultBuilder historyData = PNHistoryResult.builder();
        ArrayList<PNHistoryItemResult> messages = new ArrayList<PNHistoryItemResult>();
        MapperManager mapper = this.getPubnub().getMapper();
        if (input.body() != null) {
            Long startTimeToken = mapper.elementToLong(mapper.getArrayElement((JsonElement)input.body(), 1));
            Long endTimeToken = mapper.elementToLong(mapper.getArrayElement((JsonElement)input.body(), 2));
            if (startTimeToken == 0L && endTimeToken == 0L) {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg("History is disabled").jso((JsonElement)input.body()).build();
            }
            historyData.startTimetoken(startTimeToken);
            historyData.endTimetoken(endTimeToken);
            Iterator<JsonElement> it = mapper.getArrayIterator(mapper.getArrayElement((JsonElement)input.body(), 0));
            while (it.hasNext()) {
                JsonElement message;
                JsonElement historyEntry = it.next();
                PNHistoryItemResult.PNHistoryItemResultBuilder historyItem = PNHistoryItemResult.builder();
                if (this.includeTimetoken != null && this.includeTimetoken.booleanValue()) {
                    historyItem.timetoken(mapper.elementToLong(historyEntry, "timetoken"));
                    message = this.processMessage(mapper.getField(historyEntry, "message"));
                } else {
                    message = this.processMessage(historyEntry);
                }
                historyItem.entry(message);
                messages.add(historyItem.build());
            }
            historyData.messages(messages);
        }
        return historyData.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNHistoryOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    private JsonElement processMessage(JsonElement message) throws PubNubException {
        if (this.getPubnub().getConfiguration().getCipherKey() == null) {
            return message;
        }
        Crypto crypto = new Crypto(this.getPubnub().getConfiguration().getCipherKey());
        MapperManager mapper = this.getPubnub().getMapper();
        String inputText = mapper.isJsonObject(message) && mapper.hasField(message, "pn_other") ? mapper.elementToString(message, "pn_other") : mapper.elementToString(message);
        String outputText = crypto.decrypt(inputText);
        JsonElement outputObject = this.getPubnub().getMapper().fromJson(outputText, JsonElement.class);
        if (mapper.isJsonObject(message) && mapper.hasField(message, "pn_other")) {
            JsonObject objectNode = mapper.getAsObject(message);
            mapper.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = objectNode;
        }
        return outputObject;
    }

    public History channel(String channel) {
        this.channel = channel;
        return this;
    }

    public History start(Long start) {
        this.start = start;
        return this;
    }

    public History end(Long end) {
        this.end = end;
        return this;
    }

    public History reverse(Boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public History count(Integer count) {
        this.count = count;
        return this;
    }

    public History includeTimetoken(Boolean includeTimetoken) {
        this.includeTimetoken = includeTimetoken;
        return this;
    }
}

