/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.vendor;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class AppEngineFactory
implements Call {
    private static final Logger log = Logger.getLogger(AppEngineFactory.class.getName());
    private Request request;
    private PubNub pubNub;

    AppEngineFactory(Request request, PubNub pubNub) {
        this.request = request;
        this.pubNub = pubNub;
    }

    public Request request() {
        return this.request;
    }

    public Response execute() throws IOException {
        this.request = PubNubUtil.requestSigner(this.request, this.pubNub.getConfiguration(), this.pubNub.getTimestamp());
        URL url = this.request.url().url();
        final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setRequestMethod(this.request.method());
        Headers headers = this.request.headers();
        if (headers != null) {
            for (int i = 0; i < headers.size(); ++i) {
                String name = headers.name(i);
                connection.setRequestProperty(name, headers.get(name));
            }
        }
        if (this.request.body() != null) {
            BufferedSink outbuf = Okio.buffer((Sink)Okio.sink((OutputStream)connection.getOutputStream()));
            this.request.body().writeTo(outbuf);
            outbuf.close();
        }
        connection.connect();
        final BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)connection.getInputStream()));
        if (connection.getResponseCode() != 200) {
            throw new IOException("Fail to call  :: " + source.readUtf8());
        }
        Response response = new Response.Builder().code(connection.getResponseCode()).message(connection.getResponseMessage()).request(this.request).protocol(Protocol.HTTP_1_1).body(new ResponseBody(){

            public MediaType contentType() {
                return MediaType.parse((String)connection.getContentType());
            }

            public long contentLength() {
                return connection.getContentLengthLong();
            }

            public BufferedSource source() {
                return source;
            }
        }).build();
        return response;
    }

    public void enqueue(Callback responseCallback) {
    }

    public void cancel() {
    }

    public boolean isExecuted() {
        return false;
    }

    public boolean isCanceled() {
        return false;
    }

    public Call clone() {
        try {
            return (Call)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static class Factory
    implements Call.Factory {
        private PubNub pubNub;

        public Factory(PubNub pubNub) {
            this.pubNub = pubNub;
        }

        public Call newCall(Request request) {
            return new AppEngineFactory(request, this.pubNub);
        }
    }
}

