/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.server.FetchMessagesEnvelope;
import com.pubnub.api.models.server.HistoryForChannelsItem;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class FetchMessages
extends Endpoint<FetchMessagesEnvelope, PNFetchMessagesResult> {
    private static final int MAX_MESSAGES = 25;
    private List<String> channels = new ArrayList<String>();
    private Integer maximumPerChannel = 1;
    private Long start;
    private Long end;

    public FetchMessages(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit) {
        super(pubnub, telemetryManager, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.maximumPerChannel != null && this.maximumPerChannel > 25) {
            this.maximumPerChannel = 25;
        } else if (this.maximumPerChannel == null) {
            this.maximumPerChannel = 1;
        }
    }

    @Override
    protected Call<FetchMessagesEnvelope> doWork(Map<String, String> params) {
        params.put("max", String.valueOf(this.maximumPerChannel));
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        return this.getRetrofit().getHistoryService().fetchMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtil.joinString(this.channels, ","), params);
    }

    @Override
    protected PNFetchMessagesResult createResponse(Response<FetchMessagesEnvelope> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        PNFetchMessagesResult.PNFetchMessagesResultBuilder result = PNFetchMessagesResult.builder();
        HashMap<String, List<PNMessageResult>> listMap = new HashMap<String, List<PNMessageResult>>();
        FetchMessagesEnvelope envelope = (FetchMessagesEnvelope)input.body();
        for (Map.Entry<String, List<HistoryForChannelsItem>> entry : envelope.getChannels().entrySet()) {
            ArrayList<PNMessageResult> messages = new ArrayList<PNMessageResult>();
            for (HistoryForChannelsItem item : entry.getValue()) {
                PNMessageResult.PNMessageResultBuilder pnMessageResultBuilder = PNMessageResult.builder();
                pnMessageResultBuilder.channel(entry.getKey());
                JsonElement message = this.processMessage(item.getMessage());
                pnMessageResultBuilder.message(message);
                pnMessageResultBuilder.timetoken(item.getTimetoken());
                messages.add(pnMessageResultBuilder.build());
            }
            listMap.put(entry.getKey(), messages);
        }
        result.channels(listMap);
        return result.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNFetchMessagesOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    private JsonElement processMessage(JsonElement message) throws PubNubException {
        if (this.getPubnub().getConfiguration().getCipherKey() == null) {
            return message;
        }
        Crypto crypto = new Crypto(this.getPubnub().getConfiguration().getCipherKey());
        MapperManager mapper = this.getPubnub().getMapper();
        String inputText = mapper.isJsonObject(message) && mapper.hasField(message, "pn_other") ? mapper.elementToString(message, "pn_other") : mapper.elementToString(message);
        String outputText = crypto.decrypt(inputText);
        JsonElement outputObject = mapper.fromJson(outputText, JsonElement.class);
        if (mapper.isJsonObject(message) && mapper.hasField(message, "pn_other")) {
            JsonObject objectNode = mapper.getAsObject(message);
            mapper.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = objectNode;
        }
        return outputObject;
    }

    public FetchMessages channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public FetchMessages maximumPerChannel(Integer maximumPerChannel) {
        this.maximumPerChannel = maximumPerChannel;
        return this;
    }

    public FetchMessages start(Long start) {
        this.start = start;
        return this;
    }

    public FetchMessages end(Long end) {
        this.end = end;
        return this;
    }
}

