/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import java.util.ArrayList;
import java.util.List;

public class ListenerManager {
    private final List<SubscribeCallback> listeners = new ArrayList<SubscribeCallback>();
    private final PubNub pubnub;

    public ListenerManager(PubNub pubnubInstance) {
        this.pubnub = pubnubInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscribeCallback> getListeners() {
        ArrayList<SubscribeCallback> tempCallbackList = new ArrayList<SubscribeCallback>();
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            tempCallbackList.addAll(this.listeners);
        }
        return tempCallbackList;
    }

    public void announce(PNStatus status) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.status(this.pubnub, status);
        }
    }

    public void announce(PNMessageResult message) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.message(this.pubnub, message);
        }
    }

    public void announce(PNPresenceEventResult presence) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.presence(this.pubnub, presence);
        }
    }
}

