/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.vendor.AppEngineFactory;
import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.interceptors.SignatureInterceptor;
import com.pubnub.api.services.AccessManagerService;
import com.pubnub.api.services.ChannelGroupService;
import com.pubnub.api.services.HistoryService;
import com.pubnub.api.services.PresenceService;
import com.pubnub.api.services.PublishService;
import com.pubnub.api.services.PushService;
import com.pubnub.api.services.SubscribeService;
import com.pubnub.api.services.TimeService;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;

public class RetrofitManager {
    private PubNub pubnub;
    private SignatureInterceptor signatureInterceptor;
    private OkHttpClient transactionClientInstance;
    private OkHttpClient subscriptionClientInstance;
    private PresenceService presenceService;
    private HistoryService historyService;
    private PushService pushService;
    private AccessManagerService accessManagerService;
    private ChannelGroupService channelGroupService;
    private TimeService timeService;
    private PublishService publishService;
    private SubscribeService subscribeService;
    private Retrofit transactionInstance;
    private Retrofit subscriptionInstance;

    public RetrofitManager(PubNub pubNubInstance) {
        this.pubnub = pubNubInstance;
        this.signatureInterceptor = new SignatureInterceptor(pubNubInstance);
        if (!pubNubInstance.getConfiguration().isGoogleAppEngineNetworking()) {
            this.transactionClientInstance = this.createOkHttpClient(this.pubnub.getConfiguration().getNonSubscribeRequestTimeout(), this.pubnub.getConfiguration().getConnectTimeout());
            this.subscriptionClientInstance = this.createOkHttpClient(this.pubnub.getConfiguration().getSubscribeTimeout(), this.pubnub.getConfiguration().getConnectTimeout());
        }
        this.transactionInstance = this.createRetrofit(this.transactionClientInstance);
        this.subscriptionInstance = this.createRetrofit(this.subscriptionClientInstance);
        this.presenceService = (PresenceService)this.transactionInstance.create(PresenceService.class);
        this.historyService = (HistoryService)this.transactionInstance.create(HistoryService.class);
        this.pushService = (PushService)this.transactionInstance.create(PushService.class);
        this.accessManagerService = (AccessManagerService)this.transactionInstance.create(AccessManagerService.class);
        this.channelGroupService = (ChannelGroupService)this.transactionInstance.create(ChannelGroupService.class);
        this.publishService = (PublishService)this.transactionInstance.create(PublishService.class);
        this.subscribeService = (SubscribeService)this.subscriptionInstance.create(SubscribeService.class);
        this.timeService = (TimeService)this.transactionInstance.create(TimeService.class);
    }

    private OkHttpClient createOkHttpClient(int requestTimeout, int connectTimeOut) {
        PNConfiguration pnConfiguration = this.pubnub.getConfiguration();
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.readTimeout((long)requestTimeout, TimeUnit.SECONDS);
        httpClient.connectTimeout((long)connectTimeOut, TimeUnit.SECONDS);
        if (this.pubnub.getConfiguration().getLogVerbosity() == PNLogVerbosity.BODY) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor((Interceptor)logging);
        }
        if (this.pubnub.getConfiguration().getHttpLoggingInterceptor() != null) {
            httpClient.addInterceptor((Interceptor)this.pubnub.getConfiguration().getHttpLoggingInterceptor());
        }
        if (pnConfiguration.getSslSocketFactory() != null && pnConfiguration.getX509ExtendedTrustManager() != null) {
            httpClient.sslSocketFactory(pnConfiguration.getSslSocketFactory(), (X509TrustManager)pnConfiguration.getX509ExtendedTrustManager());
        }
        if (pnConfiguration.getConnectionSpec() != null) {
            httpClient.connectionSpecs(Collections.singletonList(pnConfiguration.getConnectionSpec()));
        }
        if (pnConfiguration.getHostnameVerifier() != null) {
            httpClient.hostnameVerifier(pnConfiguration.getHostnameVerifier());
        }
        if (this.pubnub.getConfiguration().getProxy() != null) {
            httpClient.proxy(this.pubnub.getConfiguration().getProxy());
        }
        if (this.pubnub.getConfiguration().getProxySelector() != null) {
            httpClient.proxySelector(this.pubnub.getConfiguration().getProxySelector());
        }
        if (this.pubnub.getConfiguration().getProxyAuthenticator() != null) {
            httpClient.proxyAuthenticator(this.pubnub.getConfiguration().getProxyAuthenticator());
        }
        if (this.pubnub.getConfiguration().getCertificatePinner() != null) {
            httpClient.certificatePinner(this.pubnub.getConfiguration().getCertificatePinner());
        }
        httpClient.addInterceptor((Interceptor)this.signatureInterceptor);
        OkHttpClient constructedClient = httpClient.build();
        if (this.pubnub.getConfiguration().getMaximumConnections() != null) {
            constructedClient.dispatcher().setMaxRequestsPerHost(this.pubnub.getConfiguration().getMaximumConnections().intValue());
        }
        return constructedClient;
    }

    private Retrofit createRetrofit(OkHttpClient client) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        if (this.pubnub.getConfiguration().isGoogleAppEngineNetworking()) {
            retrofitBuilder.callFactory((Call.Factory)new AppEngineFactory.Factory(this.pubnub));
        }
        retrofitBuilder = retrofitBuilder.baseUrl(this.pubnub.getBaseUrl()).addConverterFactory(this.pubnub.getMapper().getConverterFactory());
        if (!this.pubnub.getConfiguration().isGoogleAppEngineNetworking()) {
            retrofitBuilder = retrofitBuilder.client(client);
        }
        return retrofitBuilder.build();
    }

    public void destroy(boolean force) {
        if (this.transactionClientInstance != null) {
            this.closeExecutor(this.transactionClientInstance, force);
        }
        if (this.subscriptionClientInstance != null) {
            this.closeExecutor(this.subscriptionClientInstance, force);
        }
    }

    private void closeExecutor(OkHttpClient client, boolean force) {
        client.dispatcher().cancelAll();
        if (force) {
            client.connectionPool().evictAll();
            ExecutorService executorService = client.dispatcher().executorService();
            executorService.shutdown();
        }
    }

    public PresenceService getPresenceService() {
        return this.presenceService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public PushService getPushService() {
        return this.pushService;
    }

    public AccessManagerService getAccessManagerService() {
        return this.accessManagerService;
    }

    public ChannelGroupService getChannelGroupService() {
        return this.channelGroupService;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public PublishService getPublishService() {
        return this.publishService;
    }

    public SubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    public Retrofit getTransactionInstance() {
        return this.transactionInstance;
    }

    public Retrofit getSubscriptionInstance() {
        return this.subscriptionInstance;
    }
}

