/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer;

import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNErrorData;
import java.util.List;

public class PNStatus {
    private PNStatusCategory category;
    private PNErrorData errorData;
    private boolean error;
    private int statusCode;
    private PNOperationType operation;
    private boolean tlsEnabled;
    private String uuid;
    private String authKey;
    private String origin;
    private Object clientRequest;
    private List<String> affectedChannels;
    private List<String> affectedChannelGroups;
    private Endpoint executedEndpoint;

    public void retry() {
        this.executedEndpoint.retry();
    }

    PNStatus(PNStatusCategory category, PNErrorData errorData, boolean error, int statusCode, PNOperationType operation, boolean tlsEnabled, String uuid, String authKey, String origin, Object clientRequest, List<String> affectedChannels, List<String> affectedChannelGroups, Endpoint executedEndpoint) {
        this.category = category;
        this.errorData = errorData;
        this.error = error;
        this.statusCode = statusCode;
        this.operation = operation;
        this.tlsEnabled = tlsEnabled;
        this.uuid = uuid;
        this.authKey = authKey;
        this.origin = origin;
        this.clientRequest = clientRequest;
        this.affectedChannels = affectedChannels;
        this.affectedChannelGroups = affectedChannelGroups;
        this.executedEndpoint = executedEndpoint;
    }

    public static PNStatusBuilder builder() {
        return new PNStatusBuilder();
    }

    public PNStatusCategory getCategory() {
        return this.category;
    }

    public PNErrorData getErrorData() {
        return this.errorData;
    }

    public boolean isError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public PNOperationType getOperation() {
        return this.operation;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Object getClientRequest() {
        return this.clientRequest;
    }

    public List<String> getAffectedChannels() {
        return this.affectedChannels;
    }

    public List<String> getAffectedChannelGroups() {
        return this.affectedChannelGroups;
    }

    public String toString() {
        return "PNStatus(category=" + (Object)((Object)this.getCategory()) + ", errorData=" + this.getErrorData() + ", error=" + this.isError() + ", statusCode=" + this.getStatusCode() + ", operation=" + (Object)((Object)this.getOperation()) + ", tlsEnabled=" + this.isTlsEnabled() + ", uuid=" + this.getUuid() + ", authKey=" + this.getAuthKey() + ", origin=" + this.getOrigin() + ", clientRequest=" + this.getClientRequest() + ", affectedChannels=" + this.getAffectedChannels() + ", affectedChannelGroups=" + this.getAffectedChannelGroups() + ", executedEndpoint=" + this.executedEndpoint + ")";
    }

    public static class PNStatusBuilder {
        private PNStatusCategory category;
        private PNErrorData errorData;
        private boolean error;
        private int statusCode;
        private PNOperationType operation;
        private boolean tlsEnabled;
        private String uuid;
        private String authKey;
        private String origin;
        private Object clientRequest;
        private List<String> affectedChannels;
        private List<String> affectedChannelGroups;
        private Endpoint executedEndpoint;

        PNStatusBuilder() {
        }

        public PNStatusBuilder category(PNStatusCategory category) {
            this.category = category;
            return this;
        }

        public PNStatusBuilder errorData(PNErrorData errorData) {
            this.errorData = errorData;
            return this;
        }

        public PNStatusBuilder error(boolean error) {
            this.error = error;
            return this;
        }

        public PNStatusBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public PNStatusBuilder operation(PNOperationType operation) {
            this.operation = operation;
            return this;
        }

        public PNStatusBuilder tlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public PNStatusBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public PNStatusBuilder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public PNStatusBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public PNStatusBuilder clientRequest(Object clientRequest) {
            this.clientRequest = clientRequest;
            return this;
        }

        public PNStatusBuilder affectedChannels(List<String> affectedChannels) {
            this.affectedChannels = affectedChannels;
            return this;
        }

        public PNStatusBuilder affectedChannelGroups(List<String> affectedChannelGroups) {
            this.affectedChannelGroups = affectedChannelGroups;
            return this;
        }

        public PNStatusBuilder executedEndpoint(Endpoint executedEndpoint) {
            this.executedEndpoint = executedEndpoint;
            return this;
        }

        public PNStatus build() {
            return new PNStatus(this.category, this.errorData, this.error, this.statusCode, this.operation, this.tlsEnabled, this.uuid, this.authKey, this.origin, this.clientRequest, this.affectedChannels, this.affectedChannelGroups, this.executedEndpoint);
        }

        public String toString() {
            return "PNStatus.PNStatusBuilder(category=" + (Object)((Object)this.category) + ", errorData=" + this.errorData + ", error=" + this.error + ", statusCode=" + this.statusCode + ", operation=" + (Object)((Object)this.operation) + ", tlsEnabled=" + this.tlsEnabled + ", uuid=" + this.uuid + ", authKey=" + this.authKey + ", origin=" + this.origin + ", clientRequest=" + this.clientRequest + ", affectedChannels=" + this.affectedChannels + ", affectedChannelGroups=" + this.affectedChannelGroups + ", executedEndpoint=" + this.executedEndpoint + ")";
        }
    }
}

