/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManagerProperties;
import com.pubnub.api.managers.token_manager.TokenManagerPropertyProvider;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class Endpoint<Input, Output> {
    private static final Logger log = Logger.getLogger(Endpoint.class.getName());
    private PubNub pubnub;
    private RetrofitManager retrofit;
    private TelemetryManager telemetryManager;
    private PNCallback<Output> cachedCallback;
    private Call<Input> call;
    private Map<String, String> queryParam;
    private boolean silenceFailures;
    private static final int SERVER_RESPONSE_SUCCESS = 200;
    private static final int SERVER_RESPONSE_FORBIDDEN = 403;
    private static final int SERVER_RESPONSE_BAD_REQUEST = 400;
    private MapperManager mapper;

    public Endpoint(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance) {
        this.pubnub = pubnubInstance;
        this.retrofit = retrofitInstance;
        this.mapper = this.pubnub.getMapper();
        this.telemetryManager = telemetry;
    }

    @Nullable
    public Output sync() throws PubNubException {
        Response serverResponse;
        this.validateParams();
        this.call = this.doWork(this.createBaseParams());
        try {
            serverResponse = this.call.execute();
        }
        catch (IOException e) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).errormsg(e.toString()).affectedCall(this.call).build();
        }
        if (!serverResponse.isSuccessful() || serverResponse.code() != 200) {
            JsonElement responseBody;
            String responseBodyText;
            try {
                responseBodyText = serverResponse.errorBody().string();
            }
            catch (IOException e) {
                responseBodyText = "N/A";
            }
            try {
                responseBody = this.mapper.fromJson(responseBodyText, JsonElement.class);
            }
            catch (PubNubException e) {
                responseBody = null;
            }
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg(responseBodyText).jso(responseBody).statusCode(serverResponse.code()).affectedCall(this.call).build();
        }
        this.storeRequestLatency(serverResponse, this.getOperationType());
        Output response = this.createResponse(serverResponse);
        return response;
    }

    public void async(final @NotNull PNCallback<Output> callback) {
        this.cachedCallback = callback;
        try {
            this.validateParams();
            this.call = this.doWork(this.createBaseParams());
        }
        catch (PubNubException pubnubException) {
            callback.onResponse(null, this.createStatusResponse(PNStatusCategory.PNBadRequestCategory, null, pubnubException, null, null));
            return;
        }
        this.call.enqueue(new Callback<Input>(){

            public void onResponse(Call<Input> performedCall, Response<Input> response) {
                Object callbackResponse;
                if (!response.isSuccessful() || response.code() != 200) {
                    JsonElement responseBody;
                    String responseBodyText;
                    JsonElement responseBodyPayload = null;
                    ArrayList<String> affectedChannels = new ArrayList<String>();
                    ArrayList<String> affectedChannelGroups = new ArrayList<String>();
                    try {
                        responseBodyText = response.errorBody().string();
                    }
                    catch (IOException e) {
                        responseBodyText = "N/A";
                    }
                    try {
                        responseBody = Endpoint.this.mapper.fromJson(responseBodyText, JsonElement.class);
                    }
                    catch (PubNubException e) {
                        responseBody = null;
                    }
                    if (responseBody != null && Endpoint.this.mapper.isJsonObject(responseBody) && Endpoint.this.mapper.hasField(responseBody, "payload")) {
                        responseBodyPayload = Endpoint.this.mapper.getField(responseBody, "payload");
                    }
                    PNStatusCategory pnStatusCategory = PNStatusCategory.PNUnknownCategory;
                    PubNubException ex = PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg(responseBodyText).jso(responseBody).statusCode(response.code()).build();
                    if (response.code() == 403) {
                        JsonElement objNode;
                        Iterator<JsonElement> it;
                        pnStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                        if (responseBodyPayload != null && Endpoint.this.mapper.hasField(responseBodyPayload, "channels")) {
                            it = Endpoint.this.mapper.getArrayIterator(responseBodyPayload, "channels");
                            while (it.hasNext()) {
                                objNode = it.next();
                                affectedChannels.add(Endpoint.this.mapper.elementToString(objNode));
                            }
                        }
                        if (responseBodyPayload != null && Endpoint.this.mapper.hasField(responseBodyPayload, "channel-groups")) {
                            it = Endpoint.this.mapper.getArrayIterator(responseBodyPayload, "channel-groups");
                            while (it.hasNext()) {
                                objNode = it.next();
                                String channelGroupName = Endpoint.this.mapper.elementToString(objNode).substring(0, 1).equals(":") ? Endpoint.this.mapper.elementToString(objNode).substring(1) : Endpoint.this.mapper.elementToString(objNode);
                                affectedChannelGroups.add(channelGroupName);
                            }
                        }
                    }
                    if (response.code() == 400) {
                        pnStatusCategory = PNStatusCategory.PNBadRequestCategory;
                    }
                    callback.onResponse(null, Endpoint.this.createStatusResponse(pnStatusCategory, response, ex, affectedChannels, affectedChannelGroups));
                    return;
                }
                Endpoint.this.storeRequestLatency(response, Endpoint.this.getOperationType());
                try {
                    callbackResponse = Endpoint.this.createResponse(response);
                }
                catch (PubNubException pubnubException) {
                    callback.onResponse(null, Endpoint.this.createStatusResponse(PNStatusCategory.PNMalformedResponseCategory, response, pubnubException, null, null));
                    return;
                }
                callback.onResponse(callbackResponse, Endpoint.this.createStatusResponse(PNStatusCategory.PNAcknowledgmentCategory, response, null, null, null));
            }

            public void onFailure(Call<Input> performedCall, Throwable throwable) {
                PNStatusCategory pnStatusCategory;
                if (Endpoint.this.silenceFailures) {
                    return;
                }
                PubNubException.PubNubExceptionBuilder pubnubException = PubNubException.builder().errormsg(throwable.getMessage());
                try {
                    throw throwable;
                }
                catch (UnknownHostException networkException) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECTION_NOT_SET);
                    pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                }
                catch (SocketException | SSLException exception) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECT_EXCEPTION);
                    pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_TIMEOUT);
                    pnStatusCategory = PNStatusCategory.PNTimeoutCategory;
                }
                catch (Throwable throwable1) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR);
                    pnStatusCategory = performedCall.isCanceled() ? PNStatusCategory.PNCancelledCategory : PNStatusCategory.PNBadRequestCategory;
                }
                callback.onResponse(null, Endpoint.this.createStatusResponse(pnStatusCategory, null, pubnubException.build(), null, null));
            }
        });
    }

    public void retry() {
        this.silenceFailures = false;
        this.async(this.cachedCallback);
    }

    public void silentCancel() {
        if (this.call != null && !this.call.isCanceled()) {
            this.silenceFailures = true;
            this.call.cancel();
        }
    }

    private PNStatus createStatusResponse(PNStatusCategory category, Response<Input> response, Exception throwable, ArrayList<String> errorChannels, ArrayList<String> errorChannelGroups) {
        PNStatus.PNStatusBuilder pnStatus = PNStatus.builder();
        pnStatus.executedEndpoint(this);
        if (response == null || throwable != null) {
            pnStatus.error(true);
        }
        if (throwable != null) {
            PNErrorData pnErrorData = new PNErrorData(throwable.getMessage(), throwable);
            pnStatus.errorData(pnErrorData);
        }
        if (response != null) {
            pnStatus.statusCode(response.code());
            pnStatus.tlsEnabled(response.raw().request().url().isHttps());
            pnStatus.origin(response.raw().request().url().host());
            pnStatus.uuid(response.raw().request().url().queryParameter("uuid"));
            pnStatus.authKey(response.raw().request().url().queryParameter("auth"));
            pnStatus.clientRequest(response.raw().request());
        }
        pnStatus.operation(this.getOperationType());
        pnStatus.category(category);
        if (errorChannels != null && !errorChannels.isEmpty()) {
            pnStatus.affectedChannels(errorChannels);
        } else {
            pnStatus.affectedChannels(this.getAffectedChannels());
        }
        if (errorChannelGroups != null && !errorChannelGroups.isEmpty()) {
            pnStatus.affectedChannelGroups(errorChannelGroups);
        } else {
            pnStatus.affectedChannelGroups(this.getAffectedChannelGroups());
        }
        return pnStatus.build();
    }

    private void storeRequestLatency(Response response, PNOperationType type) {
        if (this.telemetryManager != null) {
            long latency = response.raw().receivedResponseAtMillis() - response.raw().sentRequestAtMillis();
            this.telemetryManager.storeLatency(latency, type);
        }
    }

    protected Map<String, String> createBaseParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.queryParam != null) {
            params.putAll(this.queryParam);
        }
        params.put("pnsdk", "PubNub-Java-Unified/".concat(this.pubnub.getVersion()));
        params.put("uuid", this.pubnub.getConfiguration().getUuid());
        if (this.pubnub.getConfiguration().isIncludeInstanceIdentifier()) {
            params.put("instanceid", this.pubnub.getInstanceId());
        }
        if (this.pubnub.getConfiguration().isIncludeRequestIdentifier()) {
            params.put("requestid", this.pubnub.getRequestId());
        }
        if (this.pubnub.getConfiguration().getAuthKey() != null && this.isAuthRequired()) {
            params.put("auth", this.pubnub.getConfiguration().getAuthKey());
        }
        if (!this.pubnub.getConfiguration().isDisableTokenManager() && this.pubnub.getConfiguration().getSecretKey() == null && this instanceof TokenManagerPropertyProvider) {
            TokenManagerProperties tokenManagerProperties = ((TokenManagerPropertyProvider)((Object)this)).getTmsProperties();
            String token = this.pubnub.getToken(tokenManagerProperties);
            if (token != null) {
                params.put("auth", token);
            } else {
                log.warning("No token found for: ".concat(tokenManagerProperties.toString()));
            }
        }
        if (this.telemetryManager != null) {
            params.putAll(this.telemetryManager.operationsLatency());
        }
        return params;
    }

    protected Map<String, String> encodeParams(Map<String, String> params) {
        HashMap<String, String> encodedParams = new HashMap<String, String>(params);
        if (encodedParams.containsKey("auth")) {
            encodedParams.put("auth", PubNubUtil.urlEncode((String)encodedParams.get("auth")));
        }
        return encodedParams;
    }

    protected <T extends Endpoint<Input, Output>> T appendInclusionParams(Map<String, String> map, Enum ... params) {
        if (params.length == 0) {
            return (T)this;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Enum param : params) {
            list.add(param.toString());
        }
        map.put("include", PubNubUtil.joinString(list, ","));
        return (T)this;
    }

    protected <T extends Endpoint<Input, Output>> T appendLimitParam(Map<String, String> map, Integer limit) {
        int maxLimit = 100;
        if (limit != null && limit > 0 && limit <= 100) {
            map.put("limit", String.valueOf(limit));
        } else {
            map.put("limit", String.valueOf(100));
        }
        map.put("limit", String.valueOf(limit));
        return (T)this;
    }

    protected abstract List<String> getAffectedChannels();

    protected abstract List<String> getAffectedChannelGroups();

    protected abstract void validateParams() throws PubNubException;

    protected abstract Call<Input> doWork(Map<String, String> var1) throws PubNubException;

    protected abstract Output createResponse(Response<Input> var1) throws PubNubException;

    protected abstract PNOperationType getOperationType();

    protected abstract boolean isAuthRequired();

    protected PubNub getPubnub() {
        return this.pubnub;
    }

    protected RetrofitManager getRetrofit() {
        return this.retrofit;
    }

    public Endpoint<Input, Output> queryParam(Map<String, String> queryParam) {
        this.queryParam = queryParam;
        return this;
    }
}

