/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.message_actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.message_actions.PNGetMessageActionsResult;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class GetMessageActions
extends Endpoint<JsonObject, PNGetMessageActionsResult> {
    private String channel;
    private Long start;
    private Long end;
    private Integer limit;

    public GetMessageActions(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance) {
        super(pubnubInstance, telemetry, retrofitInstance);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
    }

    @Override
    protected Call<JsonObject> doWork(Map<String, String> params) {
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        if (this.limit != null) {
            params.put("limit", String.valueOf(this.limit));
        }
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getMessageActionService().getMessageActions(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, params);
    }

    @Override
    protected PNGetMessageActionsResult createResponse(Response<JsonObject> input) throws PubNubException {
        PNGetMessageActionsResult.PNGetMessageActionsResultBuilder builder = PNGetMessageActionsResult.builder();
        if (input.body() != null) {
            MapperManager mapper = this.getPubnub().getMapper();
            ArrayList<PNMessageAction> pnMessageActionList = new ArrayList<PNMessageAction>();
            Iterator<JsonElement> it = mapper.getArrayIterator((JsonElement)input.body(), "data");
            while (it.hasNext()) {
                JsonElement messageActionJson = it.next();
                pnMessageActionList.add((PNMessageAction)mapper.convertValue(messageActionJson, PNMessageAction.class));
            }
            builder.actions(pnMessageActionList);
        }
        return builder.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNGetMessageActions;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public GetMessageActions channel(String channel) {
        this.channel = channel;
        return this;
    }

    public GetMessageActions start(Long start) {
        this.start = start;
        return this;
    }

    public GetMessageActions end(Long end) {
        this.end = end;
        return this;
    }

    public GetMessageActions limit(Integer limit) {
        this.limit = limit;
        return this;
    }
}

