/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.members;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNMemberFields;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.PNResourceType;
import com.pubnub.api.managers.token_manager.TokenManagerProperties;
import com.pubnub.api.managers.token_manager.TokenManagerPropertyProvider;
import com.pubnub.api.models.consumer.objects_api.member.PNGetMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNMember;
import com.pubnub.api.models.consumer.objects_api.util.FilteringParamsProvider;
import com.pubnub.api.models.consumer.objects_api.util.InclusionParamsProvider;
import com.pubnub.api.models.consumer.objects_api.util.ListingParamsProvider;
import com.pubnub.api.models.server.objects_api.EntityArrayEnvelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class GetMembers
extends Endpoint<EntityArrayEnvelope<PNMember>, PNGetMembersResult>
implements InclusionParamsProvider<GetMembers, PNMemberFields>,
ListingParamsProvider<GetMembers>,
FilteringParamsProvider<GetMembers>,
TokenManagerPropertyProvider {
    private Map<String, String> extraParamsMap = new HashMap<String, String>();
    private String spaceId;

    public GetMembers(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance) {
        super(pubnubInstance, telemetry, retrofitInstance);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return null;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.spaceId == null || this.spaceId.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SPACE_ID_MISSING).build();
        }
    }

    @Override
    protected Call<EntityArrayEnvelope<PNMember>> doWork(Map<String, String> params) {
        params.putAll(this.extraParamsMap);
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getMemberService().getMembers(this.getPubnub().getConfiguration().getSubscribeKey(), this.spaceId, params);
    }

    @Override
    protected PNGetMembersResult createResponse(Response<EntityArrayEnvelope<PNMember>> input) {
        if (input.body() != null) {
            return PNGetMembersResult.create((EntityArrayEnvelope)input.body());
        }
        return PNGetMembersResult.create();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNGetMembers;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public GetMembers includeFields(PNMemberFields ... params) {
        return (GetMembers)this.appendInclusionParams(this.extraParamsMap, params);
    }

    @Override
    public GetMembers limit(Integer limit) {
        return (GetMembers)this.appendLimitParam(this.extraParamsMap, limit);
    }

    @Override
    public GetMembers start(String start) {
        this.extraParamsMap.put("start", start);
        return this;
    }

    @Override
    public GetMembers end(String end) {
        this.extraParamsMap.put("end", end);
        return this;
    }

    @Override
    public GetMembers withTotalCount(Boolean count) {
        this.extraParamsMap.put("count", String.valueOf(count));
        return this;
    }

    @Override
    public GetMembers filter(String expression) {
        this.extraParamsMap.put("filter", PubNubUtil.urlEncode(expression));
        return this;
    }

    @Override
    public TokenManagerProperties getTmsProperties() {
        return TokenManagerProperties.builder().pnResourceType(PNResourceType.SPACE).resourceId(this.spaceId).build();
    }

    public GetMembers spaceId(String spaceId) {
        this.spaceId = spaceId;
        return this;
    }
}

