/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.memberships;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNMembershipFields;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.PNResourceType;
import com.pubnub.api.managers.token_manager.TokenManagerProperties;
import com.pubnub.api.managers.token_manager.TokenManagerPropertyProvider;
import com.pubnub.api.models.consumer.objects_api.PNPatchPayload;
import com.pubnub.api.models.consumer.objects_api.membership.Membership;
import com.pubnub.api.models.consumer.objects_api.membership.PNManageMembershipsResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembership;
import com.pubnub.api.models.consumer.objects_api.util.InclusionParamsProvider;
import com.pubnub.api.models.consumer.objects_api.util.ListingParamsProvider;
import com.pubnub.api.models.consumer.objects_api.util.MembershipChainProvider;
import com.pubnub.api.models.server.objects_api.EntityArrayEnvelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class ManageMemberships
extends Endpoint<EntityArrayEnvelope<PNMembership>, PNManageMembershipsResult>
implements InclusionParamsProvider<ManageMemberships, PNMembershipFields>,
ListingParamsProvider<ManageMemberships>,
MembershipChainProvider<ManageMemberships, Membership>,
TokenManagerPropertyProvider {
    private Map<String, String> extraParamsMap = new HashMap<String, String>();
    private PNPatchPayload<Membership> pnPatchPayload = new PNPatchPayload();
    private String userId;

    public ManageMemberships(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance) {
        super(pubnubInstance, telemetry, retrofitInstance);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return null;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.userId == null || this.userId.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_USER_ID_MISSING).build();
        }
    }

    @Override
    protected Call<EntityArrayEnvelope<PNMembership>> doWork(Map<String, String> params) {
        params.putAll(this.extraParamsMap);
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getMembershipService().manageMemberships(this.getPubnub().getConfiguration().getSubscribeKey(), this.userId, this.pnPatchPayload, params);
    }

    @Override
    protected PNManageMembershipsResult createResponse(Response<EntityArrayEnvelope<PNMembership>> input) throws PubNubException {
        if (input.body() != null) {
            return PNManageMembershipsResult.create((EntityArrayEnvelope)input.body());
        }
        return PNManageMembershipsResult.create();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNManageMemberships;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public ManageMemberships includeFields(PNMembershipFields ... params) {
        return (ManageMemberships)this.appendInclusionParams(this.extraParamsMap, params);
    }

    public ManageMemberships add(Membership ... list) {
        this.pnPatchPayload.setAdd(list);
        return this;
    }

    public ManageMemberships update(Membership ... list) {
        this.pnPatchPayload.setUpdate(list);
        return this;
    }

    public ManageMemberships remove(Membership ... list) {
        this.pnPatchPayload.setRemove(list);
        return this;
    }

    @Override
    public ManageMemberships limit(Integer limit) {
        return (ManageMemberships)this.appendLimitParam(this.extraParamsMap, limit);
    }

    @Override
    public ManageMemberships start(String start) {
        this.extraParamsMap.put("start", start);
        return this;
    }

    @Override
    public ManageMemberships end(String end) {
        this.extraParamsMap.put("end", end);
        return this;
    }

    @Override
    public ManageMemberships withTotalCount(Boolean count) {
        this.extraParamsMap.put("count", String.valueOf(count));
        return this;
    }

    @Override
    public TokenManagerProperties getTmsProperties() {
        return TokenManagerProperties.builder().pnResourceType(PNResourceType.USER).resourceId(this.userId).build();
    }

    public ManageMemberships userId(String userId) {
        this.userId = userId;
        return this;
    }
}

