/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.push;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.push.PNPushAddChannelResult;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class AddChannelsToPush
extends Endpoint<List<Object>, PNPushAddChannelResult> {
    private PNPushType pushType;
    private List<String> channels;
    private String deviceId;
    private PNPushEnvironment environment;
    private String topic;

    public AddChannelsToPush(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit) {
        super(pubnub, telemetryManager, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.pushType == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING).build();
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING).build();
        }
        if (this.channels == null || this.channels.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.pushType == PNPushType.APNS2) {
            if (this.topic == null || this.topic.isEmpty()) {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PUSH_TOPIC_MISSING).build();
            }
            if (this.environment == null) {
                this.environment = PNPushEnvironment.DEVELOPMENT;
            }
        }
    }

    @Override
    protected Call<List<Object>> doWork(Map<String, String> baseParams) throws PubNubException {
        baseParams.put("add", PubNubUtil.joinString(this.channels, ","));
        if (this.pushType != PNPushType.APNS2) {
            baseParams.put("type", this.pushType.toString());
            return this.getRetrofit().getPushService().modifyChannelsForDevice(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, baseParams);
        }
        baseParams.put("environment", this.environment.name().toLowerCase());
        baseParams.put("topic", this.topic);
        return this.getRetrofit().getPushService().modifyChannelsForDeviceApns2(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, baseParams);
    }

    @Override
    protected PNPushAddChannelResult createResponse(Response<List<Object>> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        return PNPushAddChannelResult.builder().build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNPushNotificationEnabledChannelsOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public AddChannelsToPush pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public AddChannelsToPush channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public AddChannelsToPush deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public AddChannelsToPush environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AddChannelsToPush topic(String topic) {
        this.topic = topic;
        return this;
    }
}

