/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.models.server.SubscribeMessage;
import java.util.ArrayList;

public class DuplicationManager {
    private ArrayList<String> hashHistory = new ArrayList();
    private PNConfiguration pnConfiguration;

    public DuplicationManager(PNConfiguration pnc) {
        this.pnConfiguration = pnc;
    }

    private String getKey(SubscribeMessage message) {
        return message.getPublishMetaData().getPublishTimetoken().toString().concat("-").concat(Integer.toString(message.getPayload().hashCode()));
    }

    public boolean isDuplicate(SubscribeMessage message) {
        return this.hashHistory.contains(this.getKey(message));
    }

    public void addEntry(SubscribeMessage message) {
        if (this.hashHistory.size() >= this.pnConfiguration.getMaximumMessagesCacheSize()) {
            this.hashHistory.remove(0);
        }
        this.hashHistory.add(this.getKey(message));
    }

    public void clearHistory() {
        this.hashHistory.clear();
    }
}

