/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNMembershipResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNSpaceResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNUserResult;
import java.util.ArrayList;
import java.util.List;

public class ListenerManager {
    private final List<SubscribeCallback> listeners = new ArrayList<SubscribeCallback>();
    private final PubNub pubnub;

    public ListenerManager(PubNub pubnubInstance) {
        this.pubnub = pubnubInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SubscribeCallback listener) {
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscribeCallback> getListeners() {
        ArrayList<SubscribeCallback> tempCallbackList = new ArrayList<SubscribeCallback>();
        List<SubscribeCallback> list = this.listeners;
        synchronized (list) {
            tempCallbackList.addAll(this.listeners);
        }
        return tempCallbackList;
    }

    public void announce(PNStatus status) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.status(this.pubnub, status);
        }
    }

    public void announce(PNMessageResult message) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.message(this.pubnub, message);
        }
    }

    public void announce(PNPresenceEventResult presence) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.presence(this.pubnub, presence);
        }
    }

    public void announce(PNSignalResult signal) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.signal(this.pubnub, signal);
        }
    }

    public void announce(PNUserResult user) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.user(this.pubnub, user);
        }
    }

    public void announce(PNSpaceResult space) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.space(this.pubnub, space);
        }
    }

    public void announce(PNMembershipResult membership) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.membership(this.pubnub, membership);
        }
    }

    public void announce(PNMessageActionResult messageAction) {
        for (SubscribeCallback subscribeCallback : this.getListeners()) {
            subscribeCallback.messageAction(this.pubnub, messageAction);
        }
    }
}

